/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ftp;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.ftp.FtpClientSession;
import org.exoplatform.services.log.ExoLogger;

public class FtpClientTimeOutThread
extends Thread {
    private static Log log = ExoLogger.getLogger((String)"jcr.FtpClientTimeOutThread");
    private FtpClientSession clientSession;
    private int timeOutValue;
    private int clock = 0;

    public FtpClientTimeOutThread(FtpClientSession clientSession) {
        this.clientSession = clientSession;
        this.timeOutValue = clientSession.getFtpServer().getConfiguration().getTimeOut();
    }

    public void refreshTimeOut() {
        this.clock = 0;
    }

    public void run() {
        try {
            do {
                Thread.sleep(1000L);
                ++this.clock;
            } while (this.clock < this.timeOutValue);
        }
        catch (InterruptedException iexc) {
            return;
        }
        try {
            this.clientSession.reply(String.format("421 Idle Timeout (%d seconds): closing control connection", this.timeOutValue));
        }
        catch (IOException ioexc) {
            log.info((Object)("Unhandled exception. " + ioexc.getMessage()), (Throwable)ioexc);
        }
        this.clientSession.logout();
    }
}

