/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ftp;

import java.io.File;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import org.apache.commons.chain.Catalog;
import org.apache.commons.logging.Log;
import org.exoplatform.services.command.impl.CommandService;
import org.exoplatform.services.ftp.FtpClientSession;
import org.exoplatform.services.ftp.FtpClientSessionImpl;
import org.exoplatform.services.ftp.FtpConfig;
import org.exoplatform.services.ftp.FtpDataChannelManager;
import org.exoplatform.services.ftp.FtpDataChannelManagerImpl;
import org.exoplatform.services.ftp.FtpServer;
import org.exoplatform.services.ftp.commands.FtpCommand;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;

public class FtpServerImpl
implements FtpServer {
    private static Log log = ExoLogger.getLogger((String)"jcr.ftpservice.FtpServerImpl");
    public static final String COMMAND_PATH = "/conf/ftp-commands.xml";
    private Catalog commandCatalog;
    private ManageableRepository repository;
    private FtpConfig configuration;
    private FtpAcceptThread acceptThread;
    private FtpDataChannelManager dataChannelManager;
    private ArrayList<FtpClientSession> clients = new ArrayList();

    public FtpServerImpl(FtpConfig configuration, CommandService commandService, ManageableRepository repository) throws Exception {
        this.configuration = configuration;
        this.repository = repository;
        InputStream commandStream = this.getClass().getResourceAsStream(COMMAND_PATH);
        commandService.putCatalog(commandStream);
        this.commandCatalog = commandService.getCatalog("FTP");
    }

    protected void prepareCache() {
        String[] cacheFiles;
        String cacheFolderName = this.configuration.getCacheFolderName();
        File cacheFolder = new File(cacheFolderName);
        if (!cacheFolder.exists()) {
            log.info((Object)"Cache folder not exist. Try to create it...");
            cacheFolder.mkdir();
        }
        if ((cacheFiles = cacheFolder.list()) == null) {
            log.info((Object)"No cache file in cache folder!");
            return;
        }
        for (String cacheFile : cacheFiles) {
            if (!cacheFile.endsWith(".ftpcache")) continue;
            File file = new File(cacheFolderName + "/" + cacheFile);
            file.delete();
        }
    }

    public boolean start() {
        try {
            this.prepareCache();
            ServerSocket serverSocket = new ServerSocket(this.configuration.getCommandPort());
            this.dataChannelManager = new FtpDataChannelManagerImpl(this.configuration);
            this.acceptThread = new FtpAcceptThread(this, serverSocket);
            this.acceptThread.start();
            return true;
        }
        catch (Exception exc) {
            log.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
            return false;
        }
    }

    public boolean stop() {
        return false;
    }

    public FtpConfig getConfiguration() {
        return this.configuration;
    }

    public ManageableRepository getRepository() {
        return this.repository;
    }

    public FtpCommand getCommand(String commandName) {
        return (FtpCommand)this.commandCatalog.getCommand(commandName);
    }

    public FtpDataChannelManager getDataChannelManager() {
        return this.dataChannelManager;
    }

    public boolean unRegisterClient(FtpClientSession clientSession) {
        boolean result = this.clients.remove(clientSession);
        log.info((Object)(">>> Client disconnected. Clients: " + this.clients.size()));
        return result;
    }

    public int getClientsCount() {
        return this.clients.size();
    }

    protected class FtpAcceptThread
    extends Thread {
        protected FtpServer ftpServer;
        protected ServerSocket serverSocket;
        protected boolean enable = true;

        public FtpAcceptThread(FtpServer ftpServer, ServerSocket serverSocket) {
            this.ftpServer = ftpServer;
            this.serverSocket = serverSocket;
        }

        public void disable() {
            this.enable = false;
        }

        public void run() {
            while (this.enable) {
                Socket incoming = null;
                try {
                    incoming = this.serverSocket.accept();
                    FtpClientSessionImpl clientSession = new FtpClientSessionImpl(this.ftpServer, incoming);
                    FtpServerImpl.this.clients.add(clientSession);
                    log.info((Object)(">>> New client connected. Clients: " + FtpServerImpl.this.clients.size()));
                }
                catch (Exception exc) {
                    log.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
                }
            }
        }
    }
}

