/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ftp;

import java.io.IOException;
import java.io.InputStream;
import org.exoplatform.services.ftp.FtpClientSession;

public class FtpTimeStampedInputStream
extends InputStream {
    private InputStream nativeInputStream;
    private FtpClientSession clientSession;

    public FtpTimeStampedInputStream(InputStream nativeInputStream, FtpClientSession clientSession) {
        this.nativeInputStream = nativeInputStream;
        this.clientSession = clientSession;
    }

    public int read() throws IOException {
        this.clientSession.refreshTimeOut();
        return this.nativeInputStream.read();
    }

    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public int read(byte[] buffer, int offset, int size) throws IOException {
        this.clientSession.refreshTimeOut();
        int curBlockSize = 2048;
        if (curBlockSize > size) {
            curBlockSize = size;
        }
        int readed = this.nativeInputStream.read(buffer, offset, curBlockSize);
        this.clientSession.refreshTimeOut();
        return readed;
    }

    public long skip(long skipVal) throws IOException {
        return this.nativeInputStream.skip(skipVal);
    }

    public int available() throws IOException {
        return this.nativeInputStream.available();
    }

    public void close() throws IOException {
        this.nativeInputStream.close();
    }

    public synchronized void mark(int markVal) {
        this.nativeInputStream.mark(markVal);
    }

    public synchronized void reset() throws IOException {
        this.nativeInputStream.reset();
    }

    public boolean markSupported() {
        return this.nativeInputStream.markSupported();
    }
}

