/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ftp.listcode;

import org.apache.commons.logging.Log;
import org.exoplatform.services.ftp.FtpConfig;
import org.exoplatform.services.ftp.listcode.FtpSystemCoder;
import org.exoplatform.services.ftp.listcode.FtpUnixL8Coder;
import org.exoplatform.services.ftp.listcode.FtpWindowsNTCoder;
import org.exoplatform.services.log.ExoLogger;

public class FtpSystemCoderManager {
    private static Log log = ExoLogger.getLogger((String)"jcr.ftpservice.FtpSystemCoderManager");
    private static final String[][] availableSysemCoders = new String[][]{{"Windows_NT", FtpWindowsNTCoder.class.getCanonicalName()}, {"UNIX Type: L8", FtpUnixL8Coder.class.getCanonicalName()}};

    public static FtpSystemCoder getSystemCoder(FtpConfig configuration) {
        String systemType = configuration.getSystemType();
        for (int i = 0; i < availableSysemCoders.length; ++i) {
            if (!systemType.equals(availableSysemCoders[i][0])) continue;
            try {
                FtpSystemCoder coder = (FtpSystemCoder)Class.forName(availableSysemCoders[i][1]).newInstance();
                return coder;
            }
            catch (Exception exc) {
                log.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
            }
        }
        return null;
    }
}

