/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.access;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.ext.action.InvocationContext;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.SimpleParameterEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;

public abstract class AccessManager {
    protected static Log log = ExoLogger.getLogger((String)"jcr.AccessManager");
    protected final Map<String, String> parameters = new HashMap<String, String>();
    private final OrganizationService orgService;
    private static ThreadLocal<InvocationContext> contextHolder = new ThreadLocal();

    protected AccessManager(RepositoryEntry config, WorkspaceEntry wsConfig, OrganizationService orgService) throws RepositoryException {
        if (wsConfig != null && wsConfig.getAccessManager() != null) {
            List paramList = wsConfig.getAccessManager().getParameters();
            for (SimpleParameterEntry param : paramList) {
                this.parameters.put(param.getName(), param.getValue());
            }
        }
        this.orgService = orgService;
    }

    protected final InvocationContext context() {
        return contextHolder.get();
    }

    public final void setContext(InvocationContext context) {
        contextHolder.set(context);
    }

    public final boolean hasPermission(AccessControlList acl, String permission, String userId) throws RepositoryException {
        return this.hasPermission(acl, AccessManager.parseStringPermissions(permission), userId);
    }

    public boolean hasPermission(AccessControlList acl, String[] permission, String userId) {
        if (userId.equals("__system")) {
            return true;
        }
        if (userId.equals(acl.getOwner())) {
            return true;
        }
        if (userId.equals("__anonim") && (permission.length > 1 || !permission[0].equals("read"))) {
            return false;
        }
        for (AccessControlEntry ace : acl.getPermissionEntries()) {
            if (!this.isUserMatch(ace.getIdentity(), userId) || !this.isPermissionMatch(ace.getPermission(), permission)) continue;
            return true;
        }
        return false;
    }

    protected boolean isUserMatch(String identity, String userId) {
        Iterator groups;
        if (identity.equals("any")) {
            return true;
        }
        if (identity.indexOf(":") == -1) {
            return identity.equals(userId);
        }
        String membershipName = identity.substring(0, identity.indexOf(":"));
        String groupName = identity.substring(identity.indexOf(":") + 1);
        try {
            groups = this.orgService.getGroupHandler().findGroupsOfUser(userId).iterator();
        }
        catch (Exception e) {
            log.error((Object)("AccessManager.isUserMatch() failed " + e));
            return false;
        }
        if ("*".equals(membershipName)) {
            while (groups.hasNext()) {
                Group group = (Group)groups.next();
                log.debug((Object)("Check of user " + userId + " membership. Test if " + groupName + " == " + group.getId() + " " + groupName.equals(group.getId())));
                if (!groupName.equals(group.getId())) continue;
                return true;
            }
        } else {
            while (groups.hasNext()) {
                Group group = (Group)groups.next();
                try {
                    for (Membership membership : this.orgService.getMembershipHandler().findMembershipsByUserAndGroup(userId, group.getId())) {
                        if (!membership.getMembershipType().equals(membershipName)) continue;
                        return true;
                    }
                }
                catch (Exception e) {
                    log.error((Object)("AccessManager.isUserMatch() failed " + e));
                    return false;
                }
            }
        }
        return false;
    }

    private static String[] parseStringPermissions(String str) {
        ArrayList<String> permissions = new ArrayList<String>();
        StringTokenizer parser = new StringTokenizer(str, ",");
        while (parser.hasMoreTokens()) {
            String token = parser.nextToken();
            permissions.add(token);
        }
        String[] perms = new String[permissions.size()];
        for (int i = 0; i < perms.length; ++i) {
            perms[i] = (String)permissions.get(i);
        }
        return perms;
    }

    protected final boolean isPermissionMatch(String existedPermission, String[] testPermissions) {
        try {
            for (int i = 0; i < testPermissions.length; ++i) {
                if (!existedPermission.equals(testPermissions[i])) continue;
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)("AccessManager.isPermissionMatch() exception " + e));
        }
        return false;
    }
}

