/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.config;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.jcr.config.JiBX_MungeAdapter;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallable;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;

public class RepositoryServiceConfiguration
implements IUnmarshallable,
IMarshallable {
    private ArrayList repositoryConfigurations;
    private String defaultRepositoryName;
    public static final String JiBX_bindingList = "|org.exoplatform.services.jcr.config.JiBX_api_src_resources_bindingFactory|";

    public String getDefaultRepositoryName() {
        return this.defaultRepositoryName;
    }

    public List getRepositoryConfigurations() {
        return this.repositoryConfigurations;
    }

    public RepositoryEntry getRepositoryConfiguration(String name) throws RepositoryConfigurationException {
        for (int i = 0; i < this.repositoryConfigurations.size(); ++i) {
            RepositoryEntry conf = (RepositoryEntry)this.repositoryConfigurations.get(i);
            if (!conf.getName().equals(name)) continue;
            return conf;
        }
        throw new RepositoryConfigurationException("Repository not configured " + name);
    }

    public void init(InputStream is) throws RepositoryConfigurationException {
        try {
            IBindingFactory factory = BindingDirectory.getFactory(RepositoryServiceConfiguration.class);
            IUnmarshallingContext uctx = factory.createUnmarshallingContext();
            RepositoryServiceConfiguration conf = (RepositoryServiceConfiguration)uctx.unmarshalDocument(is, null);
            this.defaultRepositoryName = conf.getDefaultRepositoryName();
            this.repositoryConfigurations = (ArrayList)conf.getRepositoryConfigurations();
        }
        catch (JiBXException e) {
            e.printStackTrace();
            throw new RepositoryConfigurationException("Error in config initialization " + (Object)((Object)e));
        }
    }

    public static RepositoryServiceConfiguration JiBX_api_src_resources_binding_newinstance_1_0(UnmarshallingContext arg1) throws JiBXException {
        return new RepositoryServiceConfiguration();
    }

    public final void JiBX_api_src_resources_binding_unmarshalAttr_1_0(UnmarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        RepositoryServiceConfiguration repositoryServiceConfiguration = this;
        this.defaultRepositoryName = arg1.attributeText(null, "default-repository");
        arg1.popObject();
    }

    public final void JiBX_api_src_resources_binding_unmarshal_1_0(UnmarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        RepositoryServiceConfiguration repositoryServiceConfiguration = this;
        arg1.parsePastStartTag(null, "repositories");
        ArrayList arrayList = this.repositoryConfigurations;
        if (arrayList == null) {
            arrayList = JiBX_MungeAdapter.JiBX_api_src_resources_binding_newinstance_1_0(arg1);
        }
        JiBX_MungeAdapter.JiBX_api_src_resources_binding_unmarshal_1_0(arrayList, arg1);
        this.repositoryConfigurations = arrayList;
        arg1.parsePastEndTag(null, "repositories");
        arg1.popObject();
    }

    public void unmarshal(IUnmarshallingContext arg1) throws JiBXException {
        Object object = arg1.getUnmarshaller(0).unmarshal((Object)this, arg1);
    }

    public final void JiBX_api_src_resources_binding_marshalAttr_1_0(MarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        MarshallingContext marshallingContext = arg1.attribute(0, "default-repository", this.defaultRepositoryName);
        arg1.popObject();
    }

    public final void JiBX_api_src_resources_binding_marshal_1_0(MarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        MarshallingContext marshallingContext = arg1.startTag(0, "repositories");
        JiBX_MungeAdapter.JiBX_api_src_resources_binding_marshal_1_0(this.repositoryConfigurations, arg1);
        arg1.endTag(0, "repositories");
        arg1.popObject();
    }

    public void marshal(IMarshallingContext arg1) throws JiBXException {
        arg1.getMarshaller(0, "org.exoplatform.services.jcr.config.RepositoryServiceConfiguration").marshal((Object)this, arg1);
    }

    public int JiBX_getIndex() {
        return 0;
    }
}

