/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.datamodel;

import org.exoplatform.commons.utils.QName;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;

public class InternalQName
extends QName {
    public InternalQName(String namespace, String name) {
        super(namespace, name);
    }

    InternalQName(String namespace, String name, boolean internal) {
        super(namespace, name, internal);
    }

    public static InternalQName parse(String qName) throws IllegalNameException {
        if (!qName.startsWith("[")) {
            throw new IllegalNameException("Invalid Internal QName '" + qName + "' Should start of '['");
        }
        int uriStart = 0;
        int uriFinish = qName.indexOf("]", uriStart);
        if (uriFinish == -1) {
            throw new IllegalNameException("Invalid Internal QName '" + qName + "' No closed ']'");
        }
        String uri = qName.substring(uriStart + 1, uriFinish);
        String localName = qName.substring(uriFinish + 1, qName.length());
        return new InternalQName(uri, localName);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof InternalQName)) {
            return false;
        }
        return this.hashCode == o.hashCode();
    }
}

