/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.storage.value;

import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.InternalQPath;
import org.exoplatform.services.jcr.datamodel.PropertyData;

public final class ValuePluginFilter {
    private final int propertyType;
    private final InternalQPath ancestorPath;
    private final InternalQName propertyName;

    public ValuePluginFilter() throws RepositoryConfigurationException {
        this(2, null, null);
    }

    public ValuePluginFilter(int propertyType, InternalQPath ancestorPath, InternalQName propertyName) throws RepositoryConfigurationException {
        if (propertyType == 0) {
            throw new RepositoryConfigurationException("Property type is obligatory");
        }
        this.propertyType = propertyType;
        this.ancestorPath = ancestorPath;
        this.propertyName = propertyName;
    }

    public InternalQPath getAncestorPath() {
        return this.ancestorPath;
    }

    public InternalQName getPropertyName() {
        return this.propertyName;
    }

    public int getPropertyType() {
        return this.propertyType;
    }

    public boolean match(PropertyData prop) {
        return !(this.propertyType != prop.getType() || this.ancestorPath != null && !prop.getQPath().isDescendantOf(this.ancestorPath, false) || this.propertyName != null && !prop.getQPath().getName().equals((Object)this.propertyName));
    }
}

