/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.util.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.exoplatform.services.jcr.util.io.CloneableInputStream;

public class LazyFileInputStream
extends CloneableInputStream {
    protected final File file;
    protected FileInputStream dataStream;

    public LazyFileInputStream(File file) {
        this.file = file;
    }

    protected File getSourceFile() {
        return this.file;
    }

    public FileChannel getChannel() throws IOException {
        return this.stream().getChannel();
    }

    protected FileInputStream stream() throws IOException {
        if (this.dataStream == null) {
            this.dataStream = new FileInputStream(this.file);
        }
        return this.dataStream;
    }

    public void close() throws IOException {
        if (this.dataStream != null) {
            super.close();
        }
    }

    public LazyFileInputStream clone() {
        return new LazyFileInputStream(this.file);
    }

    public boolean equals(Object obj) {
        if (obj instanceof LazyFileInputStream) {
            return ((LazyFileInputStream)obj).file.equals(this.file);
        }
        return super.equals(obj);
    }

    public String toString() {
        return super.toString() + ", [" + this.file.getAbsolutePath() + "]";
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.finalize();
    }
}

