/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.util.io;

import java.io.IOException;
import java.io.InputStream;

public abstract class LazyInputStream
extends InputStream {
    protected abstract InputStream stream() throws IllegalStateException, IOException;

    public int read() throws IOException {
        try {
            return this.stream().read();
        }
        catch (IllegalStateException e) {
            throw new IOException("IllegalStateException: " + e.getMessage());
        }
    }

    public int available() throws IOException {
        try {
            return this.stream().available();
        }
        catch (IllegalStateException e) {
            throw new IOException("IllegalStateException: " + e.getMessage());
        }
    }

    public void close() throws IOException {
        try {
            this.stream().close();
        }
        catch (IllegalStateException e) {
            throw new IOException("IllegalStateException: " + e.getMessage());
        }
    }

    public synchronized void mark(int readlimit) {
        try {
            this.stream().mark(readlimit);
        }
        catch (IOException e) {
            throw new RuntimeException("IOException: " + e.getMessage(), e);
        }
        catch (IllegalStateException e) {
            throw new RuntimeException("IllegalStateException: " + e.getMessage(), e);
        }
    }

    public boolean markSupported() {
        try {
            return this.stream().markSupported();
        }
        catch (IOException e) {
            throw new RuntimeException("IOException: " + e.getMessage(), e);
        }
        catch (IllegalStateException e) {
            throw new RuntimeException("IllegalStateException: " + e.getMessage(), e);
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        try {
            return this.stream().read(b, off, len);
        }
        catch (IllegalStateException e) {
            throw new IOException("IllegalStateException: " + e.getMessage());
        }
    }

    public int read(byte[] b) throws IOException {
        try {
            return this.stream().read(b);
        }
        catch (IllegalStateException e) {
            throw new IOException("IllegalStateException: " + e.getMessage());
        }
    }

    public synchronized void reset() throws IOException {
        try {
            this.stream().reset();
        }
        catch (IllegalStateException e) {
            throw new IOException("IllegalStateException: " + e.getMessage());
        }
    }

    public long skip(long n) throws IOException {
        try {
            return this.stream().skip(n);
        }
        catch (IllegalStateException e) {
            throw new IOException("IllegalStateException: " + e.getMessage());
        }
    }
}

