/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.util.io;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;

public class SharedFile
extends File {
    public static final String DELETED_EXTENSION = "del";
    protected String FILE_SUBJECT_NAME = "shared";
    private static Log log = ExoLogger.getLogger((String)"jcr.SharedFile");
    private Map<Object, Long> lockOwners = new WeakHashMap<Object, Long>();
    private volatile boolean deleted = false;
    protected boolean onFinalyzeDelete = false;
    private boolean finalyzed = false;

    protected SharedFile(String fileName) {
        super(fileName);
    }

    public synchronized boolean doDelete() {
        if (this.exists()) {
            if (this.isLockUsed()) {
                if (this.onFinalyzeDelete) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("In use. Delete on finalyze " + this.getAbsolutePath()));
                    }
                    return false;
                }
                this.onFinalyzeDelete = true;
            } else if (super.delete()) {
                this.deleteMarker();
                this.onFinalyzeDelete = false;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Deleted " + this.getAbsolutePath()));
                }
            } else {
                if (this.onFinalyzeDelete) {
                    return false;
                }
                this.onFinalyzeDelete = true;
            }
            this.onDelete();
            if (this.onFinalyzeDelete) {
                File deleteMarker = new File(this.getAbsolutePath() + "." + DELETED_EXTENSION);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Mark for delete " + deleteMarker.getAbsolutePath()));
                }
                try {
                    if (!deleteMarker.createNewFile() && log.isDebugEnabled()) {
                        log.debug((Object)("Delete marker exists or can't be created " + deleteMarker.getAbsolutePath()));
                    }
                }
                catch (IOException e) {
                    log.warn((Object)("WARNING! Can't create delete marker for file " + this.getAbsolutePath()));
                }
            }
            this.deleted = !this.onFinalyzeDelete;
            return this.deleted;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Not exists " + this.getAbsolutePath()));
        }
        this.onFinalyzeDelete = false;
        return false;
    }

    protected boolean deleteMarker() {
        File deleteMarker = new File(this.getAbsolutePath() + "." + DELETED_EXTENSION);
        if (deleteMarker.exists()) {
            if (!deleteMarker.delete()) {
                log.warn((Object)("Can't deleted marker file " + deleteMarker.getAbsolutePath()));
            }
            return true;
        }
        return false;
    }

    public boolean delete() {
        if (!this.deleted) {
            return this.doDelete();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Already deleted " + this.getAbsolutePath()));
        }
        return false;
    }

    protected void onDelete() {
    }

    protected synchronized boolean isLockUsed() {
        return !this.isFinalyzed() && this.lockOwners.size() > 0;
    }

    protected synchronized boolean lockUsed(Object lockOwner) {
        if (!this.isFinalyzed()) {
            this.lockOwners.put(lockOwner, System.currentTimeMillis());
            return true;
        }
        return false;
    }

    protected synchronized boolean unlockUsed(Object lockOwner) {
        if (!this.isFinalyzed()) {
            return this.lockOwners.remove(lockOwner) != null;
        }
        return false;
    }

    protected boolean isFinalyzed() {
        return this.finalyzed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        this.finalyzed = true;
        try {
            if (this.onFinalyzeDelete) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Delete on finalyze " + this.getAbsolutePath()));
                }
                if (!super.delete()) {
                    throw new IllegalStateException("Can not delete " + this.FILE_SUBJECT_NAME + " file " + this.getAbsolutePath() + ". File is marked as deleted by java.io.File.delete() method call.");
                }
                this.deleteMarker();
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.FILE_SUBJECT_NAME + " file deleted " + this.getAbsolutePath()));
                }
            }
        }
        finally {
            super.finalize();
        }
    }
}

