/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.util.io;

import java.util.Map;
import java.util.WeakHashMap;
import org.exoplatform.services.jcr.util.io.SharedFile;

public class StorageFile
extends SharedFile {
    private static Map<String, StorageFile> cache = new WeakHashMap<String, StorageFile>();

    protected StorageFile(String fileName) {
        super(fileName);
        this.FILE_SUBJECT_NAME = "storage";
    }

    public static StorageFile get(String path) {
        StorageFile sf = cache.get(path);
        if (sf != null && !sf.isFinalyzed() && sf.exists()) {
            return sf;
        }
        return null;
    }

    public static StorageFile create(String path) {
        StorageFile sf = StorageFile.get(path);
        if (sf == null) {
            return StorageFile.createInCache(path);
        }
        return sf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static StorageFile createInCache(String path) {
        StorageFile sf = new StorageFile(path);
        Map<String, StorageFile> map = cache;
        synchronized (map) {
            cache.put(path, sf);
        }
        return sf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static StorageFile removeFromCache(StorageFile file) {
        Map<String, StorageFile> map = cache;
        synchronized (map) {
            return cache.remove(file.getAbsolutePath());
        }
    }

    protected void onDelete() {
        StorageFile.removeFromCache(this);
    }
}

