/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.exoplatform.services.webdav.property.WebDavProperty;
import org.exoplatform.services.webdav.response.MultiStatus;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DavUtil {
    public static Node getChildNode(Node node, String childName) {
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node curNode = nodes.item(i);
            if (curNode.getLocalName() == null || !curNode.getLocalName().equals(childName)) continue;
            return curNode;
        }
        return null;
    }

    public static Document GetDocumentFromInputStream(InputStream in) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(in);
        return document;
    }

    public static Document GetDocumentFromRequest(HttpServletRequest request) throws Exception {
        Document document = null;
        String contentLength = request.getHeader("Content-Length");
        if (contentLength != null && !contentLength.equals("0")) {
            document = DavUtil.GetDocumentFromInputStream((InputStream)request.getInputStream());
        }
        return document;
    }

    private static Document getDomDocument() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.newDocument();
    }

    private static byte[] getSerializedDom(Element element) throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(element.getOwnerDocument());
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        StreamResult resultStream = new StreamResult(outStream);
        transformer.transform(source, resultStream);
        return outStream.toByteArray();
    }

    public static void sendMultistatus(HttpServletResponse response, MultiStatus multistatus) throws Exception {
        Document responseDocument = DavUtil.getDomDocument();
        Element multistatusElement = multistatus.toXml(responseDocument);
        byte[] xmlBytes = DavUtil.getSerializedDom(multistatusElement);
        response.setStatus(207);
        response.addHeader("Content-type", "text/xml;charset=UTF-8");
        response.addHeader("Content-Length", String.format("%s", xmlBytes.length));
        response.getOutputStream().write(xmlBytes, 0, xmlBytes.length);
    }

    public static void sendSingleProperty(HttpServletResponse response, WebDavProperty property) throws Exception {
        Document responseDocument = DavUtil.getDomDocument();
        Element propElement = responseDocument.createElementNS("DAV:", "D:prop");
        responseDocument.appendChild(propElement);
        property.serialize(responseDocument, propElement);
        byte[] xmlBytes = DavUtil.getSerializedDom(propElement);
        response.setStatus(200);
        response.addHeader("Content-type", "text/xml;charset=UTF-8");
        response.addHeader("Content-Length", String.format("%s", xmlBytes.length));
        response.getOutputStream().write(xmlBytes, 0, xmlBytes.length);
    }
}

