/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav;

import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.webdav.DavUtil;
import org.exoplatform.services.webdav.property.factory.PropertyConfig;
import org.exoplatform.services.webdav.property.factory.PropertyConfigTable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PropertyConfigLoader {
    private static Log log = ExoLogger.getLogger((String)"PropertyConfigLoader");
    public static final String EL_NAME = "name";
    public static final String EL_INCLUDES = "includes";
    public static final String EL_EXCLUDES = "excludes";
    public static final String EL_PROPERTY = "property";
    private PropertyConfigTable configTable = new PropertyConfigTable();

    public PropertyConfigLoader(InputStream configStream) throws Exception {
        Document configDocument = DavUtil.GetDocumentFromInputStream(configStream);
        Node elPropConfig = null;
        NodeList nodes = configDocument.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node curNode = nodes.item(i);
            if (curNode.getLocalName() == null) continue;
            elPropConfig = curNode;
            break;
        }
        if (elPropConfig == null) {
            log.info((Object)"Can't load property configuration!!!");
        }
        NodeList elNodeTypes = elPropConfig.getChildNodes();
        for (int i = 0; i < elNodeTypes.getLength(); ++i) {
            Node elNodeType = elNodeTypes.item(i);
            if (elNodeType.getLocalName() == null) continue;
            this.parseNodeType(elNodeType);
        }
    }

    private void parseNodeType(Node elNodeType) {
        Node excludeNode;
        Node nameNode = DavUtil.getChildNode(elNodeType, EL_NAME);
        String nodeTypeName = nameNode.getTextContent();
        PropertyConfig propertyConfig = new PropertyConfig();
        Node includeNode = DavUtil.getChildNode(elNodeType, EL_INCLUDES);
        if (includeNode != null) {
            NodeList properties = includeNode.getChildNodes();
            for (int i = 0; i < properties.getLength(); ++i) {
                Node propertyNode = properties.item(i);
                if (propertyNode.getLocalName() == null) continue;
                propertyConfig.setInclude(propertyNode.getTextContent());
            }
        }
        if ((excludeNode = DavUtil.getChildNode(elNodeType, EL_EXCLUDES)) != null) {
            NodeList properties = excludeNode.getChildNodes();
            for (int i = 0; i < properties.getLength(); ++i) {
                Node propertyNode = properties.item(i);
                if (propertyNode.getLocalName() == null) continue;
                propertyConfig.setExclude(propertyNode.getTextContent());
            }
        }
        this.configTable.setPropertyConfiguration(nodeTypeName, propertyConfig);
    }

    public PropertyConfigTable getConfigTable() {
        return this.configTable;
    }
}

