/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.commands;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.webdav.commands.WebDavCommand;
import org.exoplatform.services.webdav.resource.DavResource;
import org.exoplatform.services.webdav.resource.DavResourceInfo;

public class GetCommand
extends WebDavCommand {
    protected boolean process() throws RepositoryException {
        DavResource resource = this.getResourceFactory().getSrcResource(false);
        DavResourceInfo info = resource.getInfo();
        if (info.getContentType() != null) {
            this.davResponse().setResponseHeader("Content-type", info.getContentType());
        }
        InputStream resourceStream = info.getContentStream();
        long fileContentLengtn = info.getContentLength();
        long startRange = this.davRequest().getRangeStart();
        if (fileContentLengtn == 0L) {
            this.davResponse().setStatus(200);
            this.davResponse().setHeader("Content-Length", "0");
            return true;
        }
        if (startRange > fileContentLengtn - 1L) {
            this.davResponse().setStatus(416);
            return false;
        }
        long endRange = this.davRequest().getRangeEnd();
        if (endRange > fileContentLengtn - 1L) {
            this.davResponse().setStatus(416);
            return false;
        }
        if (startRange < 0L) {
            startRange = 0L;
        }
        if (endRange < 0L) {
            endRange = fileContentLengtn - 1L;
        }
        try {
            long needToRead;
            long position;
            long readed;
            byte[] buff = new byte[4096];
            boolean isPartialContent = false;
            for (position = 0L; position < startRange; position += readed) {
                isPartialContent = true;
                needToRead = buff.length;
                if (needToRead > startRange - position) {
                    needToRead = startRange - position;
                }
                if ((readed = (long)resourceStream.read(buff, 0, (int)needToRead)) < 0L) break;
            }
            this.davResponse().setStatus(isPartialContent ? 206 : 200);
            this.davResponse().setHeader("Accept-Ranges", "bytes");
            this.davResponse().setHeader("Content-Length", "" + (endRange - startRange + 1L));
            this.davResponse().setHeader("Content-Range", "bytes " + startRange + "-" + endRange + "/" + fileContentLengtn);
            while (position <= endRange) {
                needToRead = buff.length;
                if (needToRead > endRange - position + 1L) {
                    needToRead = endRange - position + 1L;
                }
                if ((readed = (long)resourceStream.read(buff, 0, (int)needToRead)) < 0L) break;
                this.davResponse().writeToResponse(buff, (int)readed);
                position += readed;
            }
            return true;
        }
        catch (SocketException exc) {
            return false;
        }
        catch (IOException ioexc) {
            return false;
        }
    }
}

