/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.commands;

import java.util.ArrayList;
import java.util.HashMap;
import javax.jcr.RepositoryException;
import org.exoplatform.services.webdav.commands.WebDavCommand;
import org.exoplatform.services.webdav.property.WebDavProperty;
import org.exoplatform.services.webdav.request.documents.PropertyUpdateDoc;
import org.exoplatform.services.webdav.request.documents.RequestDocument;
import org.exoplatform.services.webdav.resource.AbstractNodeResource;
import org.exoplatform.services.webdav.resource.DavResource;
import org.exoplatform.services.webdav.response.Href;
import org.exoplatform.services.webdav.response.MultiStatus;
import org.exoplatform.services.webdav.response.Response;
import org.exoplatform.services.webdav.response.ResponseImpl;

public class PropPatchCommand
extends WebDavCommand {
    protected boolean process() throws RepositoryException {
        WebDavProperty property;
        RequestDocument requestDoc = this.davRequest().getDocumentFromRequest();
        if (!(requestDoc instanceof PropertyUpdateDoc)) {
            this.davResponse().setStatus(412);
            return false;
        }
        DavResource resource = this.getResourceFactory().getSrcResource(false);
        if (!(resource instanceof AbstractNodeResource)) {
            this.davResponse().setStatus(403);
            return false;
        }
        HashMap<String, WebDavProperty> sets = ((PropertyUpdateDoc)requestDoc).getSetList();
        ArrayList<WebDavProperty> removes = ((PropertyUpdateDoc)requestDoc).getRemoveList();
        ResponseImpl response = new ResponseImpl();
        Href href = new Href(this.davContext(), "/" + this.davRequest().getSrcWorkspace() + this.davRequest().getSrcPath());
        response.setHref(href);
        for (String key : sets.keySet()) {
            property = sets.get(key);
            property.set(resource);
            response.addProperty(property, false);
        }
        for (int i = 0; i < removes.size(); ++i) {
            property = removes.get(i);
            property.remove(resource);
            response.addProperty(property, false);
        }
        ArrayList<Response> responses = new ArrayList<Response>();
        responses.add(response);
        this.davResponse().setMultistatus(new MultiStatus(responses));
        return true;
    }
}

