/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.commands;

import java.util.ArrayList;
import java.util.Calendar;
import javax.jcr.Node;
import org.apache.commons.logging.Log;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.webdav.FakeLockTable;
import org.exoplatform.services.webdav.commands.WebDavCommand;

public class PutCommand
extends WebDavCommand {
    private static Log log = ExoLogger.getLogger((String)"jcr.PutCommand");

    protected boolean process() throws Exception {
        String mimeType = this.davRequest().getContentType();
        if (mimeType == null) {
            String fileName = this.getFileName();
            MimeTypeResolver mimeTypeResolver = new MimeTypeResolver();
            mimeTypeResolver.setDefaultMimeType(this.davContext().getConfig().getDefFileMimeType());
            mimeType = mimeTypeResolver.getMimeType(fileName);
        }
        if (this.davRequest().getRequestStream() == null) {
            this.davResponse().answerPreconditionFailed();
            return false;
        }
        String resourcePath = this.davRequest().getSrcWorkspace() + this.davRequest().getSrcPath();
        FakeLockTable lockTable = this.davContext().getLockTable();
        String presentLockToken = lockTable.getLockToken(resourcePath);
        if (presentLockToken != null) {
            ArrayList<String> lockTokens = this.davRequest().getLockTokens();
            boolean tokenFinded = false;
            for (int i = 0; i < lockTokens.size(); ++i) {
                if (!presentLockToken.equals(lockTokens.get(i))) continue;
                tokenFinded = true;
                break;
            }
            if (!tokenFinded) {
                this.davResponse().answerForbidden();
                return false;
            }
        }
        if (this.jcrSrcSession().itemExists(this.davRequest().getSrcPath())) {
            String updatePolicyType = this.davContext().getConfig().getUpdatePolicyType();
            if (updatePolicyType.equals("add")) {
                this.createNtFile(mimeType);
            } else if (updatePolicyType.equals("create-version")) {
                this.createNtFileVersion(mimeType);
            } else {
                this.updateNtFile(mimeType);
            }
        } else {
            this.createNtFile(mimeType);
        }
        this.davResponse().answerCreated();
        return true;
    }

    protected String getFilePath() {
        String fullPath = this.davRequest().getSrcPath();
        String filePath = fullPath.substring(0, fullPath.lastIndexOf("/"));
        if ("".equals(filePath)) {
            filePath = "/";
        }
        return filePath;
    }

    protected String getFileName() {
        String fullPath = this.davRequest().getSrcPath();
        String fileName = fullPath.substring(fullPath.lastIndexOf("/"));
        if (fileName.startsWith("/")) {
            fileName = fileName.substring(1);
        }
        return fileName;
    }

    protected void createNtFile(String mimeType) throws Exception {
        Node srcNode = (Node)this.jcrSrcSession().getItem(this.getFilePath());
        String nodeType = this.davRequest().getNodeType();
        if (nodeType == null) {
            nodeType = this.davContext().getConfig().getDefFileNodeType();
        }
        Node ntFileNode = srcNode.addNode(this.getFileName(), nodeType);
        Node contentNode = ntFileNode.addNode("jcr:content", "nt:resource");
        this.fillFileContent(contentNode, mimeType);
        this.jcrSrcSession().save();
    }

    protected void updateNtFile(String mimeType) throws Exception {
        Node fileNode = (Node)this.jcrSrcSession().getItem(this.davRequest().getSrcPath());
        Node contentNode = fileNode.getNode("jcr:content");
        this.fillFileContent(contentNode, mimeType);
        this.jcrSrcSession().save();
    }

    private void fillFileContent(Node node, String mimeType) throws Exception {
        node.setProperty("jcr:mimeType", mimeType);
        node.setProperty("jcr:lastModified", Calendar.getInstance());
        node.setProperty("jcr:data", this.davRequest().getRequestStream());
    }

    protected void createNtFileVersion(String mimeType) throws Exception {
        Node fileNode = (Node)this.jcrSrcSession().getItem(this.davRequest().getSrcPath());
        if (!fileNode.isNodeType("mix:versionable")) {
            if (this.davContext().getConfig().isAutoMixLockable() && !fileNode.isNodeType("mix:lockable")) {
                fileNode.addMixin("mix:lockable");
            }
            fileNode.addMixin("mix:versionable");
            this.jcrSrcSession().save();
            fileNode.checkout();
            fileNode.checkin();
        }
        fileNode.checkout();
        this.updateNtFile(mimeType);
        fileNode.checkin();
    }
}

