/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.commands;

import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.services.webdav.FakeLockTable;
import org.exoplatform.services.webdav.commands.WebDavCommand;
import org.exoplatform.services.webdav.resource.AbstractNodeResource;
import org.exoplatform.services.webdav.resource.DavResource;
import org.exoplatform.services.webdav.resource.DeltaVResource;
import org.exoplatform.services.webdav.resource.NodeResource;

public class UnLockCommand
extends WebDavCommand {
    protected boolean process() throws RepositoryException {
        String resourcePath = this.davRequest().getSrcWorkspace() + this.davRequest().getSrcPath();
        FakeLockTable lockTable = this.davContext().getLockTable();
        String presentLockToken = lockTable.getLockToken(resourcePath);
        if (presentLockToken != null) {
            lockTable.unLockResource(resourcePath);
            this.davResponse().answerNoContent();
            return true;
        }
        DavResource resource = this.getResourceFactory().getSrcResource(false);
        if (!(resource instanceof NodeResource) && !(resource instanceof DeltaVResource)) {
            throw new AccessDeniedException();
        }
        Node node = ((AbstractNodeResource)resource).getNode();
        node.unlock();
        node.getSession().save();
        this.davResponse().answerNoContent();
        return true;
    }
}

