/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.commands;

import javax.jcr.AccessDeniedException;
import javax.jcr.LoginException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.webdav.WebDavCommandContext;
import org.exoplatform.services.webdav.request.WebDavRequest;
import org.exoplatform.services.webdav.resource.factory.ResourceFactory;
import org.exoplatform.services.webdav.resource.factory.ResourceFactoryImpl;
import org.exoplatform.services.webdav.response.WebDavResponse;

public abstract class WebDavCommand
implements Command {
    private static Log log = ExoLogger.getLogger((String)"jcr.WebDavCommand");
    protected ThreadLocal<WebDavCommandContext> commandContext = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean execute(Context context) throws Exception {
        this.commandContext.set((WebDavCommandContext)context);
        boolean status = false;
        try {
            status = this.process();
        }
        catch (LoginException lexc) {
            String wwwAuthencticate = this.davContext().getConfig().getAuthHeader();
            this.davResponse().answerUnAuthorized(wwwAuthencticate);
        }
        catch (PathNotFoundException pexc) {
            this.davResponse().answerNotFound();
        }
        catch (AccessDeniedException aexc) {
            this.davResponse().answerForbidden();
        }
        catch (RepositoryException rexr) {
            this.davResponse().answerForbidden();
        }
        finally {
            this.davContext().getSessionProvider().logOutAllSessions();
        }
        return status;
    }

    protected abstract boolean process() throws Exception;

    public final WebDavCommandContext davContext() {
        return this.commandContext.get();
    }

    public final WebDavRequest davRequest() {
        return this.commandContext.get().getWebDavRequest();
    }

    public final WebDavResponse davResponse() {
        return this.commandContext.get().getWebDavResponse();
    }

    public final ResourceFactory getResourceFactory() {
        return new ResourceFactoryImpl(this.davContext());
    }

    public final Session jcrSrcSession() throws RepositoryException {
        return this.davRequest().getSourceSession(this.davContext().getSessionProvider());
    }

    public final Session jcrDestSession() throws RepositoryException {
        return this.davRequest().getDestinationSession(this.davContext().getSessionProvider());
    }
}

