/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.commands.deltav;

import java.util.ArrayList;
import javax.jcr.RepositoryException;
import org.exoplatform.services.webdav.commands.WebDavCommand;
import org.exoplatform.services.webdav.request.documents.RequestDocument;
import org.exoplatform.services.webdav.request.documents.VersionTreeDoc;
import org.exoplatform.services.webdav.resource.DavResource;
import org.exoplatform.services.webdav.resource.DeltaVResource;
import org.exoplatform.services.webdav.response.MultiStatus;
import org.exoplatform.services.webdav.response.Response;

public class ReportCommand
extends WebDavCommand {
    protected boolean process() throws RepositoryException {
        RequestDocument requestDoc = this.davRequest().getDocumentFromRequest();
        if (!(requestDoc instanceof VersionTreeDoc)) {
            this.davResponse().answerPreconditionFailed();
            return false;
        }
        DavResource resource = this.getResourceFactory().getSrcResource(false);
        if (!(resource instanceof DeltaVResource)) {
            this.davResponse().answerForbidden();
            return false;
        }
        int depth = this.davRequest().getDepth();
        ArrayList<Response> responses = ((DeltaVResource)resource).getVersionResponces((VersionTreeDoc)requestDoc, depth);
        MultiStatus multistatus = new MultiStatus(responses);
        this.davResponse().setMultistatus(multistatus);
        return true;
    }
}

