/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.commands.deltav;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.webdav.commands.WebDavCommand;
import org.exoplatform.services.webdav.resource.AbstractNodeResource;
import org.exoplatform.services.webdav.resource.DavResource;
import org.exoplatform.services.webdav.resource.DeltaVResource;

public class RestoreCommand
extends WebDavCommand {
    private static Log log = ExoLogger.getLogger((String)"jcr.RestoreCommand");

    protected boolean process() throws RepositoryException {
        DavResource resource = this.getResourceFactory().getSrcResource(false);
        if (!(resource instanceof DeltaVResource)) {
            this.davResponse().setStatus(403);
            return false;
        }
        try {
            Node node = ((AbstractNodeResource)resource).getNode();
            Version baseVersion = node.getBaseVersion();
            Version[] predesessors = baseVersion.getPredecessors();
            if (predesessors.length < 1) {
                return true;
            }
            Version restoreToVersion = predesessors[0];
            node.restore(restoreToVersion, true);
            node.getSession().save();
        }
        catch (RepositoryException rexc) {
            log.info((Object)("Unhandled exception. " + rexc.getMessage()), (Throwable)rexc);
            throw rexc;
        }
        return true;
    }
}

