/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.commands.deltav;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.webdav.commands.WebDavCommand;
import org.exoplatform.services.webdav.resource.DavResource;
import org.exoplatform.services.webdav.resource.DeltaVResource;

public class UnCheckOutCommand
extends WebDavCommand {
    private static Log log = ExoLogger.getLogger((String)"jcr.UnCheckOutCommand");

    protected boolean process() throws RepositoryException {
        DavResource resource = this.getResourceFactory().getSrcResource(false);
        if (!(resource instanceof DeltaVResource)) {
            this.davResponse().answerForbidden();
            return false;
        }
        Node node = ((DeltaVResource)resource).getNode();
        try {
            Version restoteVersion = node.getBaseVersion();
            node.restore(restoteVersion, true);
            node.getSession().save();
        }
        catch (Exception vexc) {
            log.info((Object)("unhandled exception. " + vexc.getMessage()), (Throwable)vexc);
            this.davResponse().answerForbidden();
            return false;
        }
        this.davResponse().answerOk();
        return true;
    }
}

