/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.commands.search;

import java.util.ArrayList;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import org.exoplatform.services.webdav.commands.WebDavCommand;
import org.exoplatform.services.webdav.request.documents.RequestDocument;
import org.exoplatform.services.webdav.request.documents.SearchRequestDoc;
import org.exoplatform.services.webdav.resource.searchable.SearchableResource;
import org.exoplatform.services.webdav.response.MultiStatus;
import org.exoplatform.services.webdav.response.Response;
import org.exoplatform.services.webdav.search.Search;

public class SearchCommand
extends WebDavCommand {
    protected boolean process() throws RepositoryException {
        RequestDocument requestDocument = this.davRequest().getDocumentFromRequest();
        if (!(requestDocument instanceof SearchRequestDoc)) {
            this.davResponse().setStatus(400);
            return false;
        }
        SearchableResource resource = this.getResourceFactory().getSearchableResource();
        Search search = ((SearchRequestDoc)requestDocument).getSearch();
        ArrayList<Response> responses = null;
        try {
            responses = resource.doSearch(search);
        }
        catch (InvalidQueryException qexc) {
            qexc.printStackTrace();
            this.davResponse().setStatus(400);
            return false;
        }
        MultiStatus multistatus = new MultiStatus(responses);
        this.davResponse().setMultistatus(multistatus);
        return true;
    }
}

