/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.order;

import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.webdav.DavUtil;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OrderMember {
    private static Log log = ExoLogger.getLogger((String)"jcr.OrderMember");
    private String segment;
    private int position = 0;
    private String positionSegment;

    public String getSegment() {
        return this.segment;
    }

    public int getposition() {
        return this.position;
    }

    public String getpositionSegment() {
        return this.positionSegment;
    }

    public boolean initFromDom(Node memberNode) {
        try {
            Node segmentNode = DavUtil.getChildNode(memberNode, "segment");
            this.segment = segmentNode.getTextContent();
            Node positionNode = DavUtil.getChildNode(memberNode, "position");
            NodeList nodes = positionNode.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node positionValNode = nodes.item(i);
                if ("first".equals(positionValNode.getLocalName())) {
                    this.position = 0;
                    return true;
                }
                if ("last".equals(positionValNode.getLocalName())) {
                    this.position = 1;
                    return true;
                }
                if ("before".equals(positionValNode.getLocalName())) {
                    this.position = 2;
                    this.positionSegment = DavUtil.getChildNode(positionValNode, "segment").getTextContent();
                    return true;
                }
                if (!"after".equals(positionValNode.getLocalName())) continue;
                this.position = 3;
                this.positionSegment = DavUtil.getChildNode(positionValNode, "segment").getTextContent();
                return true;
            }
        }
        catch (Exception exc) {
            log.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
        }
        return false;
    }
}

