/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.property.dav;

import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.exoplatform.services.webdav.property.dav.AbstractDAVProperty;
import org.exoplatform.services.webdav.resource.AbstractNodeResource;
import org.exoplatform.services.webdav.resource.DavResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CreationDateProp
extends AbstractDAVProperty {
    protected String creationDate = "";

    public CreationDateProp() {
        super("creationdate");
    }

    protected boolean initialize(DavResource resource) throws RepositoryException {
        if (!(resource instanceof AbstractNodeResource)) {
            return false;
        }
        Node node = ((AbstractNodeResource)resource).getNode();
        if (node.isNodeType("nt:version")) {
            node = node.getNode("jcr:frozenNode");
        }
        if (!node.hasProperty("jcr:created")) {
            return false;
        }
        Property createdProp = node.getProperty("jcr:created");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ENGLISH);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.creationDate = dateFormat.format(createdProp.getDate().getTime());
        this.status = 200;
        return true;
    }

    public void serialize(Document rootDoc, Element parentElement) {
        super.serialize(rootDoc, parentElement);
        if (this.status != 200) {
            return;
        }
        this.propertyElement.setTextContent(this.creationDate);
    }
}

