/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.property.dav;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.services.webdav.property.dav.AbstractDAVProperty;
import org.exoplatform.services.webdav.resource.AbstractNodeResource;
import org.exoplatform.services.webdav.resource.DavResource;
import org.exoplatform.services.webdav.resource.DeltaVResource;
import org.exoplatform.services.webdav.resource.NodeResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LockDiscoveryProp
extends AbstractDAVProperty {
    protected boolean isLocked = false;
    protected String lockType = "write";
    protected String lockScope = "exclusive";
    protected int depth = 0;
    protected String timeOut = "Second-2592000";
    protected String owner = "eXo-Platform manage system.";
    protected String lockToken = "";

    public LockDiscoveryProp() {
        super("lockdiscovery");
    }

    public void setLocked(boolean isLocked) {
        this.isLocked = isLocked;
    }

    public boolean getLocked() {
        return this.isLocked;
    }

    public void setLockType(String lockType) {
        this.lockType = lockType;
    }

    public String getLockType() {
        return this.lockType;
    }

    public void setLockScope(String lockScope) {
        this.lockScope = lockScope;
    }

    public String getLockScope() {
        return this.lockScope;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setTimeOut(String timeOut) {
        this.timeOut = timeOut;
    }

    public String getTimeOut() {
        return this.timeOut;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setLockToken(String lockToken) {
        this.lockToken = lockToken;
    }

    public String getLockToken() {
        return this.lockToken;
    }

    protected boolean initialize(DavResource resource) throws RepositoryException {
        if (!(resource instanceof NodeResource) && !(resource instanceof DeltaVResource)) {
            return false;
        }
        Node node = ((AbstractNodeResource)resource).getNode();
        if (node.isLocked()) {
            this.isLocked = true;
            this.owner = node.getLock().getLockOwner();
        }
        this.status = 200;
        return true;
    }

    public void serialize(Document rootDoc, Element parentElement) {
        super.serialize(rootDoc, parentElement);
        if (this.status != 200 || !this.isLocked) {
            return;
        }
        Element elActiveLock = rootDoc.createElement("D:activelock");
        this.propertyElement.appendChild(elActiveLock);
        Element elLockType = rootDoc.createElement("D:locktype");
        elActiveLock.appendChild(elLockType);
        Element elLockTypeWrite = rootDoc.createElement("D:write");
        elLockType.appendChild(elLockTypeWrite);
        Element elLockScope = rootDoc.createElement("D:lockscope");
        elActiveLock.appendChild(elLockScope);
        Element elLockScopeExclusicve = rootDoc.createElement("D:exclusive");
        elLockScope.appendChild(elLockScopeExclusicve);
        Element elDepth = rootDoc.createElement("D:depth");
        elActiveLock.appendChild(elDepth);
        if (this.depth < 0) {
            elDepth.setTextContent("Infinity");
        } else {
            elDepth.setTextContent(String.format("%s", this.depth));
        }
        Element elOwner = rootDoc.createElement("D:owner");
        elActiveLock.appendChild(elOwner);
        elOwner.setTextContent(this.owner);
        Element elTimeOut = rootDoc.createElement("D:timeout");
        elActiveLock.appendChild(elTimeOut);
        if ("".equals(this.timeOut)) {
            elTimeOut.setTextContent("Infinity");
        } else {
            elTimeOut.setTextContent(this.timeOut);
        }
        if (!"".equals(this.lockToken)) {
            Element elLockToken = rootDoc.createElement("D:locktoken");
            elActiveLock.appendChild(elLockToken);
            Element elLockTokenHref = rootDoc.createElement("D:href");
            elLockToken.appendChild(elLockTokenHref);
            elLockTokenHref.setTextContent(this.lockToken);
        }
    }
}

