/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.property.dav;

import javax.jcr.RepositoryException;
import org.exoplatform.services.webdav.property.dav.AbstractDAVProperty;
import org.exoplatform.services.webdav.resource.DavResource;
import org.exoplatform.services.webdav.resource.VersionResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ResourceTypeProp
extends AbstractDAVProperty {
    protected String resourceType = "collection";

    public ResourceTypeProp() {
        super("resourcetype");
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    protected boolean initialize(DavResource resource) throws RepositoryException {
        DavResource curResource = null;
        curResource = resource instanceof VersionResource ? ((VersionResource)resource).getOwnResource() : resource;
        if (!curResource.isCollection()) {
            this.resourceType = "resource";
        }
        this.status = 200;
        return true;
    }

    public void serialize(Document rootDoc, Element parentElement) {
        super.serialize(rootDoc, parentElement);
        if (200 != this.status) {
            return;
        }
        if ("collection".equals(this.resourceType)) {
            Element collection = rootDoc.createElement("D:collection");
            this.propertyElement.appendChild(collection);
        }
    }
}

