/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.property.dav;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import org.exoplatform.services.webdav.property.dav.AbstractDAVProperty;
import org.exoplatform.services.webdav.resource.DavResource;
import org.exoplatform.services.webdav.resource.VersionResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SuccessorSetProp
extends AbstractDAVProperty {
    protected ArrayList<String> versionSuccessors = new ArrayList();

    public SuccessorSetProp() {
        super("successor-set");
    }

    protected boolean initialize(DavResource resource) throws RepositoryException {
        if (!(resource instanceof VersionResource)) {
            return false;
        }
        Node node = ((VersionResource)resource).getNode();
        if (!(node instanceof Version)) {
            return false;
        }
        Version[] successors = ((Version)node).getSuccessors();
        while (successors.length > 0) {
            this.versionSuccessors.add(this.resourceHref + "?VERSIONID=" + successors[0].getName());
            successors = successors[0].getSuccessors();
        }
        this.status = 200;
        return true;
    }

    public void serialize(Document rootDoc, Element parentElement) {
        super.serialize(rootDoc, parentElement);
        if (this.status != 200) {
            return;
        }
        for (int i = 0; i < this.versionSuccessors.size(); ++i) {
            Element hrefEl = rootDoc.createElement("D:href");
            this.propertyElement.appendChild(hrefEl);
            hrefEl.setTextContent(this.versionSuccessors.get(i));
        }
    }
}

