/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.property.dav;

import java.util.ArrayList;
import javax.jcr.RepositoryException;
import org.exoplatform.services.webdav.property.dav.AbstractDAVProperty;
import org.exoplatform.services.webdav.resource.DavResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SupportedMethodSetProp
extends AbstractDAVProperty {
    private ArrayList<String> availableMethods = new ArrayList();

    public SupportedMethodSetProp() {
        super("supported-method-set");
    }

    protected boolean initialize(DavResource resource) throws RepositoryException {
        this.availableMethods = resource.getAvailableMethods();
        this.status = 200;
        return true;
    }

    public void serialize(Document rootDoc, Element parentElement) {
        super.serialize(rootDoc, parentElement);
        if (this.status != 200) {
            return;
        }
        for (int i = 0; i < this.availableMethods.size(); ++i) {
            String curMethodName = this.availableMethods.get(i);
            Element methodElement = rootDoc.createElement("D:supported-method");
            this.propertyElement.appendChild(methodElement);
            methodElement.setAttribute("name", curMethodName);
        }
    }
}

