/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.property.factory;

import java.util.ArrayList;
import java.util.HashMap;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.services.webdav.property.factory.PropertyMapping;
import org.exoplatform.services.webdav.resource.AbstractNodeResource;
import org.exoplatform.services.webdav.resource.DavResource;
import org.exoplatform.services.webdav.resource.VersionResource;

public class MappingTable {
    private HashMap<String, ArrayList<PropertyMapping>> mappings = new HashMap();

    public void mapProperty(String nodeTypeName, PropertyMapping mapping) {
        ArrayList<PropertyMapping> curMappings = this.mappings.get(nodeTypeName);
        if (curMappings == null) {
            curMappings = new ArrayList();
            curMappings.add(mapping);
            this.mappings.put(nodeTypeName, curMappings);
        } else {
            curMappings.add(mapping);
        }
    }

    public PropertyMapping getMapping(String propertyName, DavResource resource) throws RepositoryException {
        Node node;
        String nodeTypeName;
        ArrayList<PropertyMapping> curMappings;
        if (!(resource instanceof AbstractNodeResource)) {
            return null;
        }
        DavResource calculatedResource = resource;
        if (resource instanceof VersionResource) {
            calculatedResource = ((VersionResource)resource).getOwnResource();
        }
        if ((curMappings = this.mappings.get(nodeTypeName = (node = ((AbstractNodeResource)calculatedResource).getNode()).getPrimaryNodeType().getName())) == null && (curMappings = this.mappings.get("*")) == null) {
            return null;
        }
        for (int i = 0; i < curMappings.size(); ++i) {
            PropertyMapping curMapping = curMappings.get(i);
            if (!curMapping.getPropertyName().equalsIgnoreCase(propertyName)) continue;
            return curMapping;
        }
        return null;
    }
}

