/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.property.factory;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.webdav.property.factory.PropertyDefine;
import org.exoplatform.services.webdav.property.factory.PropertyFactory;
import org.exoplatform.services.webdav.resource.AbstractNodeResource;
import org.exoplatform.services.webdav.resource.DavResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyCollector {
    private static Log log = ExoLogger.getLogger((String)"jcr.PropertyCollector");
    private PropertyFactory propertyFactory;

    public PropertyCollector(PropertyFactory propertyFactory) {
        this.propertyFactory = propertyFactory;
    }

    public ArrayList<PropertyDefine> searchPropertiesForResource(DavResource resource) throws RepositoryException {
        ArrayList<PropertyDefine> defines = new ArrayList<PropertyDefine>();
        if (!(resource instanceof AbstractNodeResource)) {
            return defines;
        }
        Node workNode = ((AbstractNodeResource)resource).getNode();
        ArrayList<String> allProp = this.collectProperties(workNode);
        for (int i = 0; i < allProp.size(); ++i) {
            String curPropName = allProp.get(i);
            if (curPropName.indexOf(":") > 0) {
                String propPrefix = curPropName.substring(0, curPropName.indexOf(":") + 1);
                String propName = curPropName.substring(curPropName.indexOf(":") + 1);
                PropertyDefine curDefine = this.propertyFactory.getDefine(propPrefix, propName);
                defines.add(curDefine);
                continue;
            }
            log.info((Object)"PROPERTY NOT PREFIXED!!!!!!!!!!!!");
        }
        ArrayList<PropertyDefine> allNotExcluded = new ArrayList<PropertyDefine>();
        for (int i = 0; i < defines.size(); ++i) {
            PropertyDefine curDefine = defines.get(i);
            if (curDefine.isNeedExclude(resource)) continue;
            allNotExcluded.add(curDefine);
        }
        return allNotExcluded;
    }

    private ArrayList<String> collectProperties(Node workNode) throws RepositoryException {
        ArrayList<String> properties = new ArrayList<String>();
        PropertyIterator workPropIter = workNode.getProperties();
        while (workPropIter.hasNext()) {
            Property curProperty = workPropIter.nextProperty();
            String curPropertyName = curProperty.getName();
            if (properties.contains(curPropertyName)) continue;
            properties.add(curPropertyName);
        }
        if (workNode.hasNode("jcr:content")) {
            Node contentNode = workNode.getNode("jcr:content");
            PropertyIterator contentPropIter = contentNode.getProperties();
            while (contentPropIter.hasNext()) {
                Property contentProp = contentPropIter.nextProperty();
                String curPropertyName = contentProp.getName();
                if (properties.contains(curPropertyName)) continue;
                properties.add(curPropertyName);
            }
        }
        return properties;
    }
}

