/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.request.documents;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.services.webdav.property.factory.PropertyCollector;
import org.exoplatform.services.webdav.property.factory.PropertyDefine;
import org.exoplatform.services.webdav.property.factory.PropertyFactory;
import org.exoplatform.services.webdav.request.documents.RequestDocument;
import org.exoplatform.services.webdav.resource.AbstractNodeResource;
import org.exoplatform.services.webdav.resource.DavResource;
import org.exoplatform.services.webdav.resource.VersionResource;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonPropDoc
implements RequestDocument {
    protected ArrayList<PropertyDefine> defines = new ArrayList();
    protected boolean isNeedSearchProperties = true;
    private PropertyFactory propertyFactory;

    public void initFactory(PropertyFactory propertyFactory) {
        this.propertyFactory = propertyFactory;
    }

    @Override
    public boolean init(Document requestDocument, PropertyFactory propertyFactory) {
        this.propertyFactory = propertyFactory;
        return false;
    }

    public ArrayList<PropertyDefine> getDefines() {
        return this.defines;
    }

    public boolean isNeedSearchProperties() {
        return this.isNeedSearchProperties;
    }

    public ArrayList<PropertyDefine> searchPropertiesForResource(DavResource resource) throws RepositoryException {
        ArrayList<PropertyDefine> curDefines = new ArrayList<PropertyDefine>();
        curDefines.addAll(this.loadPreSetForResource(resource));
        PropertyCollector collector = new PropertyCollector(this.propertyFactory);
        curDefines.addAll(collector.searchPropertiesForResource(resource));
        return curDefines;
    }

    public ArrayList<PropertyDefine> loadPreSetForResource(DavResource resource) throws RepositoryException {
        String nodeTypeName = "*";
        DavResource calculatedResource = resource;
        if (resource instanceof VersionResource) {
            calculatedResource = ((VersionResource)resource).getOwnResource();
        }
        if (calculatedResource instanceof AbstractNodeResource) {
            Node node = ((AbstractNodeResource)calculatedResource).getNode();
            nodeTypeName = node.getPrimaryNodeType().getName();
        }
        return this.propertyFactory.getDefines(nodeTypeName);
    }
}

