/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.request.documents;

import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.webdav.DavUtil;
import org.exoplatform.services.webdav.property.factory.PropertyFactory;
import org.exoplatform.services.webdav.request.documents.RequestDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class LockInfoDoc
implements RequestDocument {
    private static Log log = ExoLogger.getLogger((String)"jcr.LockInfoDoc");
    protected String lockType = "write";
    protected String lockScope = "exclusive";
    protected String lockOwner = "";
    protected String lockOwnerHref = "";

    public boolean init(Document requestDocument, PropertyFactory propertyFactory) {
        try {
            Node nOwner;
            Node nScope;
            Node nWrite;
            Node nLockInfo = DavUtil.getChildNode(requestDocument, "lockinfo");
            Node nLockType = DavUtil.getChildNode(nLockInfo, "locktype");
            if (nLockType != null && (nWrite = DavUtil.getChildNode(nLockType, "write")) != null) {
                this.lockType = "write";
            }
            if ((nScope = DavUtil.getChildNode(nLockInfo, "lockscope")) != null) {
                Node nShared;
                Node nExclusive = DavUtil.getChildNode(nScope, "exclusive");
                if (nExclusive != null) {
                    this.lockScope = "exclusive";
                }
                if ((nShared = DavUtil.getChildNode(nScope, "shared")) != null) {
                    this.lockScope = "shared";
                }
            }
            if ((nOwner = DavUtil.getChildNode(nLockInfo, "owner")) != null) {
                this.lockOwner = nOwner.getTextContent();
                Node nOwnerHref = DavUtil.getChildNode(nOwner, "href");
                if (nOwnerHref != null) {
                    this.lockOwnerHref = nOwnerHref.getTextContent();
                }
            }
            return true;
        }
        catch (Exception exc) {
            log.info((Object)("Can't fill document data. " + exc.getMessage()));
            exc.printStackTrace();
            return false;
        }
    }

    public String getLockType() {
        return this.lockType;
    }

    public String getLockScope() {
        return this.lockScope;
    }

    public String getLockOwner() {
        return this.lockOwner;
    }

    public String getLockOwnerHref() {
        return this.lockOwnerHref;
    }
}

