/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.request.documents;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.webdav.DavUtil;
import org.exoplatform.services.webdav.order.OrderMember;
import org.exoplatform.services.webdav.property.factory.PropertyFactory;
import org.exoplatform.services.webdav.request.documents.CommonPropDoc;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderPatchDoc
extends CommonPropDoc {
    private static Log log = ExoLogger.getLogger((String)"jcr.OrderPatchDoc");
    private ArrayList<OrderMember> members = new ArrayList();

    public ArrayList<OrderMember> getMembers() {
        return this.members;
    }

    @Override
    public boolean init(Document requestDocument, PropertyFactory propertyFactory) {
        try {
            Node orderPatch = DavUtil.getChildNode(requestDocument, "orderpatch");
            NodeList childs = orderPatch.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                OrderMember member;
                Node child = childs.item(i);
                if (!"order-member".equals(child.getLocalName()) || !(member = new OrderMember()).initFromDom(child)) continue;
                this.members.add(member);
            }
            return true;
        }
        catch (Exception exc) {
            log.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
            return false;
        }
    }
}

