/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.request.documents;

import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.webdav.DavUtil;
import org.exoplatform.services.webdav.property.factory.PropertyDefine;
import org.exoplatform.services.webdav.property.factory.PropertyFactory;
import org.exoplatform.services.webdav.request.documents.CommonPropDoc;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PropertyRequiredDoc
extends CommonPropDoc {
    private static Log log = ExoLogger.getLogger((String)"jcr.PropertyRequiredDoc");
    protected String xmlName = "propfind";

    public boolean init(Document requestDocument, PropertyFactory propertyFactory) {
        super.init(requestDocument, propertyFactory);
        try {
            Node propFind = DavUtil.getChildNode(requestDocument, this.xmlName);
            if (DavUtil.getChildNode(propFind, "allprop") != null) {
                this.isNeedSearchProperties = true;
                return true;
            }
            this.defines.clear();
            Node props = DavUtil.getChildNode(propFind, "prop");
            if (DavUtil.getChildNode(props, "allprop") != null) {
                this.isNeedSearchProperties = true;
                return true;
            }
            NodeList nodes = props.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node curNode = nodes.item(i);
                String nameSpace = curNode.getNamespaceURI();
                String localName = curNode.getLocalName();
                if (localName == null) continue;
                PropertyDefine define = propertyFactory.getDefine(nameSpace, localName);
                this.defines.add(define);
            }
            Node propInclude = DavUtil.getChildNode(propFind, "include");
            if (propInclude != null) {
                log.info((Object)"Needed extended include property.");
            }
            this.isNeedSearchProperties = false;
            return true;
        }
        catch (Exception exc) {
            log.info((Object)("Can't fill document data. " + exc.getMessage()));
            exc.printStackTrace();
            return false;
        }
    }
}

