/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.request.documents;

import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.webdav.DavUtil;
import org.exoplatform.services.webdav.property.factory.PropertyFactory;
import org.exoplatform.services.webdav.request.documents.RequestDocument;
import org.exoplatform.services.webdav.search.Search;
import org.exoplatform.services.webdav.search.SearchConst;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SearchRequestDoc
implements RequestDocument {
    private static Log log = ExoLogger.getLogger((String)"jcr.SearchRequestDoc");
    private Search search;

    public Search getSearch() {
        return this.search;
    }

    private Search getSearch(String name) throws Exception {
        for (int i = 0; i < SearchConst.SEARCH_TEMPLATES.length; ++i) {
            String curSearchName = SearchConst.SEARCH_TEMPLATES[i][0];
            if (!curSearchName.equals(name)) continue;
            return (Search)Class.forName(SearchConst.SEARCH_TEMPLATES[i][1]).newInstance();
        }
        return null;
    }

    public boolean init(Document requestDocument, PropertyFactory propertyFactory) {
        try {
            Node searchRequestN = DavUtil.getChildNode(requestDocument, "searchrequest");
            NodeList nodes = searchRequestN.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node searchNode = nodes.item(i);
                if (searchNode.getLocalName() == null) continue;
                this.search = this.getSearch(searchNode.getLocalName());
                this.search.init(searchNode);
                break;
            }
        }
        catch (Throwable exc) {
            log.info((Object)("Unhandled exception. " + exc.getMessage()), exc);
            return false;
        }
        return true;
    }
}

