/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.resource;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.services.webdav.WebDavCommandContext;
import org.exoplatform.services.webdav.request.documents.CommonPropDoc;
import org.exoplatform.services.webdav.resource.DavCommonResource;
import org.exoplatform.services.webdav.resource.DavResource;
import org.exoplatform.services.webdav.resource.DavResourceInfo;
import org.exoplatform.services.webdav.resource.DavResourceInfoImpl;
import org.exoplatform.services.webdav.resource.NodeResource;
import org.exoplatform.services.webdav.response.Href;
import org.exoplatform.services.webdav.response.Response;
import org.exoplatform.services.webdav.response.ResponseImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractNodeResource
extends DavCommonResource {
    private Node resourceNode;

    public AbstractNodeResource(WebDavCommandContext context, Node node) throws RepositoryException {
        super(context);
        this.resourceNode = node;
    }

    @Override
    public Session getSession() throws RepositoryException {
        return this.resourceNode.getSession();
    }

    @Override
    public boolean isCollection() throws RepositoryException {
        return !this.resourceNode.isNodeType("nt:file");
    }

    @Override
    public String getName() throws RepositoryException {
        return this.resourceNode.getName();
    }

    protected DavResourceInfo getInfo(Node node, boolean isCollection) throws RepositoryException {
        DavResourceInfoImpl info = new DavResourceInfoImpl();
        info.setName(node.getName());
        if (isCollection) {
            if (node.hasProperty("jcr:created")) {
                info.setLastModified(node.getProperty("jcr:created").getString());
            }
        } else {
            info.setType(false);
            Node contentNode = node.getNode("jcr:content");
            if (node.hasProperty("jcr:lastModified")) {
                info.setLastModified(contentNode.getProperty("jcr:lastModified").getString());
            }
            info.setContentType(contentNode.getProperty("jcr:mimeType").getString());
            Property dataProperty = contentNode.getProperty("jcr:data");
            info.setContentStream(dataProperty.getStream());
            info.setContentLength(dataProperty.getLength());
            info.setType(false);
        }
        return info;
    }

    @Override
    public DavResourceInfo getInfo() throws RepositoryException {
        return this.getInfo(this.resourceNode, this.isCollection());
    }

    @Override
    public ArrayList<String> getAvailableMethods() {
        return this.context.getAvailableCommands();
    }

    public String getHref() throws RepositoryException {
        return "/" + this.resourceNode.getSession().getWorkspace().getName() + this.resourceNode.getPath();
    }

    public String getShortHref() throws RepositoryException {
        return this.getHref();
    }

    @Override
    public Response getResponse(CommonPropDoc reqProps) throws RepositoryException {
        ResponseImpl response = new ResponseImpl();
        response.setHref(new Href(this.context, this.getHref()));
        this.initResponse(reqProps, response);
        return response;
    }

    @Override
    public ArrayList<DavResource> getChildsResources() throws RepositoryException {
        ArrayList<DavResource> childs = new ArrayList<DavResource>();
        NodeIterator childIter = this.resourceNode.getNodes();
        while (childIter.hasNext()) {
            Node childNode = childIter.nextNode();
            NodeResource resource = new NodeResource(this.context, childNode);
            childs.add(resource);
        }
        return childs;
    }

    @Override
    public int getChildCount() throws RepositoryException {
        if (this.resourceNode.isNodeType("nt:file")) {
            return 0;
        }
        return (int)this.resourceNode.getNodes().getSize();
    }

    public Node getNode() {
        return this.resourceNode;
    }
}

