/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.resource;

import java.util.ArrayList;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.services.webdav.WebDavCommandContext;
import org.exoplatform.services.webdav.property.WebDavProperty;
import org.exoplatform.services.webdav.property.factory.PropertyDefine;
import org.exoplatform.services.webdav.request.documents.CommonPropDoc;
import org.exoplatform.services.webdav.resource.DavResource;
import org.exoplatform.services.webdav.resource.DavResourceInfo;
import org.exoplatform.services.webdav.response.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DavCommonResource
implements DavResource {
    protected WebDavCommandContext context;

    public DavCommonResource(WebDavCommandContext context) {
        this.context = context;
    }

    @Override
    public abstract boolean isCollection() throws RepositoryException;

    @Override
    public abstract String getName() throws RepositoryException;

    @Override
    public abstract DavResourceInfo getInfo() throws RepositoryException;

    @Override
    public ArrayList<String> getAvailableMethods() {
        return this.context.getAvailableCommands();
    }

    @Override
    public Session getSession() throws RepositoryException {
        return null;
    }

    protected void initResponse(CommonPropDoc reqProps, Response response) throws RepositoryException {
        ArrayList<PropertyDefine> defines = null;
        boolean isNeedSearch = reqProps.isNeedSearchProperties();
        defines = isNeedSearch ? reqProps.searchPropertiesForResource(this) : reqProps.getDefines();
        for (int i = 0; i < defines.size(); ++i) {
            PropertyDefine define = defines.get(i);
            WebDavProperty property = define.getProperty();
            property.refresh123(this, response.getHref());
            response.addProperty(property, isNeedSearch);
        }
    }

    @Override
    public abstract Response getResponse(CommonPropDoc var1) throws RepositoryException;

    @Override
    public abstract ArrayList<DavResource> getChildsResources() throws RepositoryException;

    @Override
    public abstract int getChildCount() throws RepositoryException;

    @Override
    public final ArrayList<Response> getChildsResponses(CommonPropDoc reqProps, int depth) throws RepositoryException {
        ArrayList<Response> responses = new ArrayList<Response>();
        Response curResponse = this.getResponse(reqProps);
        if (curResponse != null) {
            responses.add(curResponse);
        }
        if (depth > 0 && this.isCollection()) {
            ArrayList<DavResource> childs = this.getChildsResources();
            for (int i = 0; i < childs.size(); ++i) {
                DavResource child = childs.get(i);
                if (child.isCollection()) {
                    responses.addAll(child.getChildsResponses(reqProps, depth - 1));
                    continue;
                }
                responses.add(child.getResponse(reqProps));
            }
        }
        return responses;
    }
}

