/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.resource;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.webdav.WebDavCommandContext;
import org.exoplatform.services.webdav.request.WebDavRequest;
import org.exoplatform.services.webdav.request.documents.CommonPropDoc;
import org.exoplatform.services.webdav.resource.DavResource;
import org.exoplatform.services.webdav.resource.DavResourceInfo;
import org.exoplatform.services.webdav.resource.NodeResource;
import org.exoplatform.services.webdav.response.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FakeResource
implements DavResource {
    private static Log log = ExoLogger.getLogger((String)"jcr.FakeResource");
    private WebDavCommandContext context;
    private Node rootNode;
    private String resPath;

    public FakeResource(WebDavCommandContext context, Node rootNode, String resPath) {
        this.context = context;
        this.rootNode = rootNode;
        this.resPath = resPath;
    }

    public String getPath() {
        return this.resPath;
    }

    public DavResource createAsCollection() throws RepositoryException {
        String[] pathes = this.resPath.split("/");
        WebDavRequest request = this.context.getWebDavRequest();
        String nodeType = request.getNodeType();
        if (nodeType == null) {
            nodeType = this.context.getConfig().getDefFolderNodeType();
        }
        Node node = this.rootNode;
        for (int i = 0; i < pathes.length; ++i) {
            if ("".equals(pathes[i])) continue;
            node = node.hasNode(pathes[i]) ? node.getNode(pathes[i]) : node.addNode(pathes[i], nodeType);
        }
        node.getSession().save();
        try {
            ArrayList<String> mixTypes = request.getMixTypes();
            for (int mi = 0; mi < mixTypes.size(); ++mi) {
                node.addMixin(mixTypes.get(mi));
            }
            node.getSession().save();
        }
        catch (RepositoryException exc) {
            log.info((Object)("Unhandled exception " + exc.getMessage()), (Throwable)exc);
        }
        return new NodeResource(this.context, node);
    }

    @Override
    public boolean isCollection() throws RepositoryException {
        throw new PathNotFoundException();
    }

    @Override
    public String getName() throws RepositoryException {
        throw new PathNotFoundException();
    }

    @Override
    public DavResourceInfo getInfo() throws RepositoryException {
        throw new PathNotFoundException();
    }

    @Override
    public ArrayList<String> getAvailableMethods() {
        return null;
    }

    @Override
    public Session getSession() throws RepositoryException {
        return this.rootNode.getSession();
    }

    @Override
    public Response getResponse(CommonPropDoc reqProps) throws RepositoryException {
        throw new PathNotFoundException();
    }

    @Override
    public ArrayList<DavResource> getChildsResources() throws RepositoryException {
        throw new PathNotFoundException();
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public ArrayList<Response> getChildsResponses(CommonPropDoc reqProps, int depth) throws RepositoryException {
        throw new PathNotFoundException();
    }
}

