/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.resource;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import javax.jcr.RepositoryException;
import org.exoplatform.services.webdav.WebDavCommandContext;
import org.exoplatform.services.webdav.request.documents.CommonPropDoc;
import org.exoplatform.services.webdav.resource.DavCommonResource;
import org.exoplatform.services.webdav.resource.DavResource;
import org.exoplatform.services.webdav.resource.DavResourceInfo;
import org.exoplatform.services.webdav.resource.DavResourceInfoImpl;
import org.exoplatform.services.webdav.resource.WorkspaceResource;
import org.exoplatform.services.webdav.response.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryResource
extends DavCommonResource {
    public RepositoryResource(WebDavCommandContext context) {
        super(context);
    }

    @Override
    public boolean isCollection() throws RepositoryException {
        return true;
    }

    @Override
    public String getName() throws RepositoryException {
        return "";
    }

    @Override
    public DavResourceInfo getInfo() throws RepositoryException {
        DavResourceInfoImpl info = new DavResourceInfoImpl();
        info.setContentStream(new ByteArrayInputStream("".getBytes()));
        return info;
    }

    @Override
    public Response getResponse(CommonPropDoc reqProps) throws RepositoryException {
        return null;
    }

    @Override
    public ArrayList<DavResource> getChildsResources() throws RepositoryException {
        String[] workspaces = this.context.getAvailableWorkspaces();
        ArrayList<DavResource> childs = new ArrayList<DavResource>();
        for (String workspace : workspaces) {
            childs.add(new WorkspaceResource(this.context, workspace));
        }
        return childs;
    }

    @Override
    public int getChildCount() {
        return this.context.getAvailableWorkspaces().length;
    }
}

