/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.resource.factory;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.Version;
import org.exoplatform.services.webdav.WebDavCommandContext;
import org.exoplatform.services.webdav.request.WebDavRequest;
import org.exoplatform.services.webdav.resource.DavResource;
import org.exoplatform.services.webdav.resource.DeltaVResource;
import org.exoplatform.services.webdav.resource.FakeResource;
import org.exoplatform.services.webdav.resource.NodeResource;
import org.exoplatform.services.webdav.resource.RepositoryResource;
import org.exoplatform.services.webdav.resource.VersionResource;
import org.exoplatform.services.webdav.resource.WorkspaceResource;
import org.exoplatform.services.webdav.resource.factory.ResourceFactory;
import org.exoplatform.services.webdav.resource.searchable.SearchableNode;
import org.exoplatform.services.webdav.resource.searchable.SearchableRepository;
import org.exoplatform.services.webdav.resource.searchable.SearchableResource;
import org.exoplatform.services.webdav.resource.searchable.SearchableWorkspace;

public class ResourceFactoryImpl
implements ResourceFactory {
    private WebDavCommandContext context;

    public ResourceFactoryImpl(WebDavCommandContext context) {
        this.context = context;
    }

    public SearchableResource getSearchableResource() throws RepositoryException {
        WebDavRequest request = this.context.getWebDavRequest();
        String workspace = request.getSrcWorkspace();
        String path = request.getSrcPath();
        if ("/".equals(path)) {
            if ("".equals(workspace)) {
                return new SearchableRepository(this.context);
            }
            return new SearchableWorkspace(this.context, workspace);
        }
        Session session = request.getSourceSession(this.context.getSessionProvider());
        return new SearchableNode(this.context, (Node)session.getItem(path));
    }

    public DavResource getSrcResource(boolean enableFake) throws RepositoryException {
        WebDavRequest request = this.context.getWebDavRequest();
        String workspace = request.getSrcWorkspace();
        String path = request.getSrcPath();
        if ("/".equals(path)) {
            if ("".equals(workspace)) {
                return new RepositoryResource(this.context);
            }
            return new WorkspaceResource(this.context, workspace);
        }
        Session session = request.getSourceSession(this.context.getSessionProvider());
        try {
            Node node = (Node)session.getItem(path);
            if (node.isNodeType("mix:versionable")) {
                String srcVersion = request.getSrcVersion();
                if (srcVersion != null) {
                    Version selectedVersion = node.getVersionHistory().getVersion(srcVersion);
                    return new VersionResource(this.context, selectedVersion, new DeltaVResource(this.context, node));
                }
                return new DeltaVResource(this.context, node);
            }
            return new NodeResource(this.context, node);
        }
        catch (PathNotFoundException pexc) {
            if (enableFake) {
                return new FakeResource(this.context, session.getRootNode(), path);
            }
            throw new PathNotFoundException();
        }
    }

    public DavResource getDestinationResource() throws RepositoryException {
        return null;
    }
}

