/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.response;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.webdav.WebDavCommandContext;
import org.exoplatform.services.webdav.resource.DavResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlBuilder {
    private static Log log = ExoLogger.getLogger((String)"jcr.HtmlBuilder");
    public static final String HTML_PATH = "/exo/projects/v2.x/exo-jcr/services/webdav/src/java/resource/page.html";
    public static final String HTML_FOLDERS = "/exo/projects/v2.x/exo-jcr/services/webdav/src/java/resource/folders.html";
    public static final String HTML_FILES = "/exo/projects/v2.x/exo-jcr/services/webdav/src/java/resource/files.html";
    public static final String MASK_NAME = "<!--$davName-->";
    public static final String MASK_INNER = "<!--$davInnerHtml-->";
    public static final String MASK_IMAGE = "<!--$davImgage-->";
    public static final String MASK_HREF = "<!--$davHref-->";
    public static final String MASK_FILENAME = "<!--$davFileName-->";
    public static final String MASK_FILESIZE = "<!--$davFileSize-->";
    private WebDavCommandContext context;

    public HtmlBuilder(WebDavCommandContext context) {
        this.context = context;
    }

    private String getHtmlResource(String resName) throws Exception {
        int readed;
        File f = new File(resName);
        FileInputStream fins = new FileInputStream(f);
        ByteArrayOutputStream outS = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while ((readed = fins.read(buffer)) >= 0) {
            outS.write(buffer, 0, readed);
        }
        fins.close();
        String html = new String(outS.toByteArray());
        return html;
    }

    private String getListHtml(String path, ArrayList<DavResource> resources) throws Exception {
        String htmlPreset = this.getHtmlResource(HTML_FILES);
        String html = "";
        String serverApp = this.context.getWebDavRequest().getServerApp();
        String serverPrefix = this.context.getWebDavRequest().getServerPrefix();
        for (int i = 0; i < resources.size(); ++i) {
            DavResource resource = resources.get(i);
            String rImage = "";
            if (resource.isCollection()) {
                rImage = serverApp + "/images/folder.gif";
            }
            String rHref = serverPrefix + path + resource.getName();
            log.info((Object)("HREF: [" + rHref + "]"));
            String rName = resource.getName();
            html = html + htmlPreset.replace(MASK_IMAGE, rImage).replace(MASK_HREF, rHref).replace(MASK_FILENAME, rName);
        }
        return html;
    }

    public InputStream getHtml(String path, ArrayList<DavResource> resources) {
        log.info((Object)("LOCAL HREF: [" + path + "]"));
        String serverApp = this.context.getWebDavRequest().getServerApp();
        String serverPrefix = this.context.getWebDavRequest().getServerPrefix();
        try {
            String html = this.getHtmlResource(HTML_PATH);
            String allDirs = MASK_INNER;
            String rootDir = this.getHtmlResource(HTML_FOLDERS).replace(MASK_IMAGE, serverApp + "/images/folder.gif").replace(MASK_NAME, "repository").replace(MASK_HREF, serverPrefix);
            allDirs = allDirs.replace(MASK_INNER, rootDir);
            String[] pathes = path.split("/");
            for (int i = pathes.length - 1; i >= 0; --i) {
                log.info((Object)"filling for FOLDER >>>>>>>>>>>>>>>>>>");
                String curPath = pathes[i];
            }
            html = html.replace(MASK_INNER, allDirs);
            return new ByteArrayInputStream(html.getBytes());
        }
        catch (Exception exc) {
            log.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
            return null;
        }
    }
}

