/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.response;

import java.util.ArrayList;
import java.util.HashMap;
import org.exoplatform.services.webdav.property.WebDavProperty;
import org.exoplatform.services.webdav.response.DavStatus;
import org.exoplatform.services.webdav.response.Href;
import org.exoplatform.services.webdav.response.Response;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ResponseImpl
implements Response {
    private Href href;
    private int status = -1;
    private String description;
    private ArrayList<WebDavProperty> propertyes = new ArrayList();

    public void setHref(Href href) {
        this.href = href;
    }

    public Href getHref() {
        return this.href;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void addProperty(WebDavProperty property, boolean excludeNotOk) {
        if (excludeNotOk && property.getStatus() != 200) {
            return;
        }
        this.propertyes.add(property);
    }

    public void toXml(Document rootDoc, Element multistatusElement) {
        Element response = rootDoc.createElement("D:response");
        multistatusElement.appendChild(response);
        this.href.serialize(rootDoc, response);
        if (this.status > 0) {
            Element statusEl = rootDoc.createElement("D:status");
            response.appendChild(statusEl);
            statusEl.setTextContent(DavStatus.getStatusDescription(this.status));
        }
        if (this.description != null) {
            Element descriptionEl = rootDoc.createElement("D:responsedescription");
            response.appendChild(descriptionEl);
            descriptionEl.setTextContent(this.description);
        }
        HashMap<Integer, ArrayList<WebDavProperty>> propStatusGroups = new HashMap<Integer, ArrayList<WebDavProperty>>();
        HashMap<String, String> nameSpaces = new HashMap<String, String>();
        for (WebDavProperty curProp : this.propertyes) {
            int curPropStat;
            ArrayList<WebDavProperty> propGroup;
            String nameSpace;
            String propertyName = curProp.getName();
            if (propertyName.indexOf(":") > 0 && !(nameSpace = propertyName.substring(0, propertyName.indexOf(":"))).equals("DAV") && nameSpaces.get(nameSpace) == null) {
                nameSpaces.put(nameSpace, nameSpace);
            }
            if ((propGroup = (ArrayList<WebDavProperty>)propStatusGroups.get(curPropStat = curProp.getStatus())) == null) {
                propGroup = new ArrayList<WebDavProperty>();
                propStatusGroups.put(new Integer(curPropStat), propGroup);
            }
            propGroup.add(curProp);
        }
        for (String nameSpace : nameSpaces.keySet()) {
            response.setAttribute("xmlns:" + nameSpace, nameSpace + ":");
        }
        for (Integer curStatus : propStatusGroups.keySet()) {
            Element propStat = rootDoc.createElement("D:propstat");
            response.appendChild(propStat);
            Element prop = rootDoc.createElement("D:prop");
            propStat.appendChild(prop);
            ArrayList propList = (ArrayList)propStatusGroups.get(curStatus);
            for (int i = 0; i < propList.size(); ++i) {
                WebDavProperty curProp = (WebDavProperty)propList.get(i);
                curProp.serialize(rootDoc, prop);
            }
            Element status = rootDoc.createElement("D:status");
            propStat.appendChild(status);
            status.setTextContent(DavStatus.getStatusDescription(curStatus));
        }
    }
}

