/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.search.basicsearch.convertor;

import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import org.exoplatform.services.webdav.search.basicsearch.convertor.dasl.DASLDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DASLConvertor {
    private String text_tag_type = "text";
    private String start_tag_type = "start_tag";
    private String end_tag_type = "end_tag";
    private String empty_tag_type = "empty_tag";
    private String nl_tag_type = "NL";
    private String dasl_prefix;
    private String jcr_path = "jcr:path";
    private String select_name = "select";
    private String from_name = "from";
    private String where_name = "where";
    private String orderby_name = "orderby";
    private String order_name = "order";
    private String ascending_name = "ascending";
    private String descending_name = "descending";
    private String prop_name = "prop";
    private String allprop_name = "allprop";
    private String scope_name = "href";
    private String href_name = "href";
    private String lt_name = "lt";
    private String lte_name = "lte";
    private String gt_name = "gt";
    private String gte_name = "gte";
    private String eq_name = "eq";
    private String or_name = "or";
    private String and_name = "and";
    private String not_name = "not";
    private String like_name = "like";
    private String contains_name = "contains";
    private String literal_name = "literal";
    private String sql_star_name = "*";
    private String sql_comma_name = ",";
    private String sql_orderby_name = "order by";
    private String sql_ascending_name = "asc";
    private String sql_descending_name = "desc";
    private String sql_lt_name = "<";
    private String sql_lte_name = "<=";
    private String sql_gt_name = ">";
    private String sql_gte_name = ">=";
    private String sql_eq_name = "=";
    private String sql_and_name = "and";
    private String sql_or_name = "or";
    private String sql_not_name = "not";
    private String sql_like_name = "like";
    private String sql_contains_name = "contains";
    private String sql_where_name = "where";
    private String sql_from_name = "from";
    private DASLDocument select_doc;
    private DASLDocument from_doc;
    private DASLDocument where_doc;
    private DASLDocument orderby_doc;
    private String select_converted = "";
    private String from_to_from_converted = "";
    private String from_to_where_converted = "";
    private String where_converted = "";
    private String orderby_converted = "";
    private Vector<String> from_elements;

    public DASLConvertor(Vector<String> els) {
        this.setFromElements(els);
    }

    public void setDASLPrefix(String prefix) {
        this.dasl_prefix = prefix;
    }

    public void setFromElements(Vector<String> els) {
        this.from_elements = els;
    }

    public Vector<String> getFromElements() {
        return this.from_elements;
    }

    public String convertQuery(DASLDocument doc) {
        this.select_doc = this.prepareBlock(doc, this.select_name);
        this.from_doc = this.prepareBlock(doc, this.from_name);
        this.where_doc = this.prepareBlock(doc, this.where_name);
        this.orderby_doc = this.prepareBlock(doc, this.orderby_name);
        if (this.select_doc != null) {
            this.select_doc = this.filterSelectBlock(this.select_doc);
        }
        if (this.from_doc != null) {
            this.from_doc = this.filterFromBlock(this.from_doc);
        }
        if (this.where_doc != null) {
            this.where_doc = this.filterOrderbyBlock(this.where_doc);
        }
        if (this.orderby_doc != null) {
            this.orderby_doc = this.filterWhereBlock(this.orderby_doc);
        }
        if (this.select_doc != null) {
            this.select_converted = this.convertSelect(this.select_doc);
        }
        if (this.from_doc != null) {
            this.from_to_where_converted = this.convertFromToWhere(this.from_doc);
        }
        if (this.from_doc != null) {
            this.from_to_from_converted = this.convertFromToFrom(this.from_doc);
        }
        if (this.where_doc != null) {
            this.where_converted = this.convertWhere(this.where_doc);
        }
        if (this.orderby_doc != null) {
            this.orderby_converted = this.convertOrderby(this.orderby_doc);
        }
        String result_query = this.select_converted + this.from_to_from_converted;
        if (!this.where_converted.equals("")) {
            result_query = result_query + this.where_converted;
            result_query = result_query + this.from_to_where_converted;
        } else {
            result_query = result_query + this.sql_where_name.toUpperCase() + " " + this.from_to_where_converted.substring(3, this.from_to_where_converted.length());
        }
        result_query = result_query + this.orderby_converted;
        return result_query;
    }

    public DASLDocument prepareBlock(DASLDocument doc, String block_name) {
        boolean status = false;
        boolean non_empty_status = false;
        DASLDocument.ElementSequence s = new DASLDocument.ElementSequence();
        Enumeration e = doc.getElements().elements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            String type = ((DASLDocument.DASLElement)o).getType();
            String name = ((DASLDocument.DASLElement)o).getName();
            if (type.equalsIgnoreCase(this.start_tag_type) && name.equalsIgnoreCase(this.dasl_prefix + block_name)) {
                status = true;
            }
            if (type.equalsIgnoreCase(this.end_tag_type) && name.equalsIgnoreCase(this.dasl_prefix + block_name) && status) {
                return new DASLDocument(s);
            }
            if (!status || name.equalsIgnoreCase(this.dasl_prefix + block_name)) continue;
            s.addElement((DASLDocument.DASLElement)o);
            non_empty_status = true;
        }
        if (non_empty_status) {
            return new DASLDocument(s);
        }
        return null;
    }

    public DASLDocument filterSelectBlock(DASLDocument dd) {
        boolean status = false;
        DASLDocument.ElementSequence s = new DASLDocument.ElementSequence();
        Enumeration e = dd.getElements().elements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            String type = ((DASLDocument.DASLElement)o).getType();
            String name = ((DASLDocument.DASLElement)o).getName();
            if (type.equalsIgnoreCase(this.empty_tag_type) && name.equalsIgnoreCase(this.dasl_prefix + this.allprop_name)) {
                s = new DASLDocument.ElementSequence();
                s.addElement((DASLDocument.DASLElement)o);
                return new DASLDocument(s);
            }
            if (type.equalsIgnoreCase(this.empty_tag_type) && name.startsWith(this.dasl_prefix)) continue;
            s.addElement((DASLDocument.DASLElement)o);
        }
        return new DASLDocument(s);
    }

    public DASLDocument filterFromBlock(DASLDocument dd) {
        return dd;
    }

    public DASLDocument filterWhereBlock(DASLDocument dd) {
        return dd;
    }

    public DASLDocument filterOrderbyBlock(DASLDocument dd) {
        return dd;
    }

    public String convertSelect(DASLDocument doc) {
        boolean status = false;
        StringBuffer query_block = new StringBuffer(this.select_name.toUpperCase() + " ");
        Enumeration e = doc.getElements().elements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            String type = ((DASLDocument.DASLElement)o).getType();
            String name = ((DASLDocument.DASLElement)o).getName();
            if (type.equalsIgnoreCase(this.start_tag_type) && name.equalsIgnoreCase(this.dasl_prefix + this.prop_name)) {
                status = true;
            }
            if (type.equalsIgnoreCase(this.end_tag_type) && name.equalsIgnoreCase(this.dasl_prefix + this.prop_name)) {
                status = false;
            }
            if (type.equalsIgnoreCase(this.empty_tag_type) && name.equalsIgnoreCase(this.dasl_prefix + this.allprop_name)) {
                query_block.append(this.sql_star_name + " ");
                return query_block.toString();
            }
            if (!type.equalsIgnoreCase(this.empty_tag_type) || !status) continue;
            query_block.append(name + this.sql_comma_name + " ");
        }
        if (!query_block.toString().equalsIgnoreCase(this.select_name.toUpperCase() + " ")) {
            query_block.delete(query_block.length() - this.sql_comma_name.length() - 1, query_block.length() - 1);
            return query_block.toString();
        }
        return new String(this.select_name.toUpperCase() + " " + this.sql_star_name + " ");
    }

    public String convertFromToFrom(DASLDocument doc) {
        StringBuffer query_block = new StringBuffer(this.from_name.toUpperCase() + " ");
        Enumeration<String> e = this.from_elements.elements();
        while (e.hasMoreElements()) {
            String o;
            String name = o = e.nextElement();
            query_block.append(name + ", ");
        }
        if (query_block.toString().equalsIgnoreCase(this.from_name.toUpperCase() + " ")) {
            return "";
        }
        if (query_block.toString().endsWith(", ")) {
            query_block.delete(query_block.length() - 2, query_block.length() - 1);
        }
        return query_block.toString();
    }

    public String convertFromToWhere(DASLDocument doc) {
        boolean scope_status = false;
        boolean status = false;
        StringBuffer query_block = new StringBuffer("");
        Enumeration e = doc.getElements().elements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            String type = ((DASLDocument.DASLElement)o).getType();
            String name = ((DASLDocument.DASLElement)o).getName();
            if (type.equalsIgnoreCase(this.start_tag_type) && name.equalsIgnoreCase(this.dasl_prefix + this.scope_name)) {
                scope_status = true;
            }
            if (type.equalsIgnoreCase(this.start_tag_type) && name.equalsIgnoreCase(this.dasl_prefix + this.href_name)) {
                status = true;
            }
            if (type.equalsIgnoreCase(this.end_tag_type) && name.equalsIgnoreCase(this.dasl_prefix + this.href_name)) {
                status = false;
            }
            if (type.equalsIgnoreCase(this.end_tag_type) && name.equalsIgnoreCase(this.dasl_prefix + this.scope_name)) {
                scope_status = false;
            }
            if (!(o instanceof DASLDocument.Text) || !status || !scope_status) continue;
            query_block.append(this.sql_and_name.toUpperCase() + " " + this.jcr_path + " " + this.sql_like_name.toUpperCase() + " '" + ((DASLDocument.Text)o).getContent() + "' ");
        }
        if (query_block.toString().equalsIgnoreCase("")) {
            return "";
        }
        return query_block.toString();
    }

    public String convertWhere(DASLDocument doc) {
        StringBuffer query_block = new StringBuffer(this.sql_where_name.toUpperCase() + " ");
        boolean status = false;
        boolean prop_status = false;
        boolean value_status = false;
        int condition_status = 0;
        String status_tag_name = "";
        Stack<String> condition_name = new Stack<String>();
        Enumeration e = doc.getElements().elements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            String type = ((DASLDocument.DASLElement)o).getType();
            String name = ((DASLDocument.DASLElement)o).getName();
            if (type.equalsIgnoreCase(this.start_tag_type) && name.equalsIgnoreCase(this.dasl_prefix + this.not_name) && name.equalsIgnoreCase(this.dasl_prefix + this.not_name)) {
                query_block.append(this.sql_not_name.toUpperCase() + " ");
            }
            if (type.equalsIgnoreCase(this.start_tag_type) && (name.equalsIgnoreCase(this.dasl_prefix + this.or_name) || name.equalsIgnoreCase(this.dasl_prefix + this.and_name))) {
                ++condition_status;
                if (name.equalsIgnoreCase(this.dasl_prefix + this.or_name)) {
                    condition_name.push(this.sql_or_name);
                }
                if (name.equalsIgnoreCase(this.dasl_prefix + this.and_name)) {
                    condition_name.push(this.sql_and_name);
                }
            }
            if (type.equalsIgnoreCase(this.start_tag_type) && !status && (name.equalsIgnoreCase(this.dasl_prefix + this.lt_name) || name.equalsIgnoreCase(this.dasl_prefix + this.lte_name) || name.equalsIgnoreCase(this.dasl_prefix + this.gt_name) || name.equalsIgnoreCase(this.dasl_prefix + this.gte_name) || name.equalsIgnoreCase(this.dasl_prefix + this.eq_name) || name.equalsIgnoreCase(this.dasl_prefix + this.like_name) || name.equalsIgnoreCase(this.dasl_prefix + this.contains_name))) {
                status = true;
                status_tag_name = name;
            }
            if (type.equalsIgnoreCase(this.end_tag_type) && status && (name.equalsIgnoreCase(this.dasl_prefix + this.lt_name) || name.equalsIgnoreCase(this.dasl_prefix + this.lte_name) || name.equalsIgnoreCase(this.dasl_prefix + this.gt_name) || name.equalsIgnoreCase(this.dasl_prefix + this.gte_name) || name.equalsIgnoreCase(this.dasl_prefix + this.eq_name) || name.equalsIgnoreCase(this.dasl_prefix + this.like_name) || name.equalsIgnoreCase(this.dasl_prefix + this.contains_name))) {
                status = false;
                status_tag_name = "";
                if (condition_status != 0) {
                    query_block.append(((String)condition_name.pop()).toUpperCase() + " ");
                    --condition_status;
                }
            }
            if (type.equalsIgnoreCase(this.start_tag_type) && name.equalsIgnoreCase(this.dasl_prefix + this.prop_name) && status && !prop_status) {
                prop_status = true;
            }
            if (type.equalsIgnoreCase(this.end_tag_type) && name.equalsIgnoreCase(this.dasl_prefix + this.prop_name) && status && prop_status) {
                prop_status = false;
            }
            if (type.equalsIgnoreCase(this.start_tag_type) && name.equalsIgnoreCase(this.dasl_prefix + this.literal_name) && status && !value_status) {
                value_status = true;
            }
            if (type.equalsIgnoreCase(this.end_tag_type) && name.equalsIgnoreCase(this.dasl_prefix + this.literal_name) && status && value_status) {
                value_status = false;
            }
            if (type.equalsIgnoreCase(this.empty_tag_type) && status && prop_status) {
                query_block.append(name + " ");
                continue;
            }
            if (o instanceof DASLDocument.Text && status && !prop_status && value_status) {
                String operation = null;
                if (status_tag_name.equalsIgnoreCase(this.dasl_prefix + this.lt_name)) {
                    operation = this.sql_lt_name.toUpperCase();
                } else if (status_tag_name.equalsIgnoreCase(this.dasl_prefix + this.lte_name)) {
                    operation = this.sql_lte_name.toUpperCase();
                } else if (status_tag_name.equalsIgnoreCase(this.dasl_prefix + this.gt_name)) {
                    operation = this.sql_gt_name.toUpperCase();
                } else if (status_tag_name.equalsIgnoreCase(this.dasl_prefix + this.gte_name)) {
                    operation = this.sql_gte_name.toUpperCase();
                } else if (status_tag_name.equalsIgnoreCase(this.dasl_prefix + this.eq_name)) {
                    operation = this.sql_eq_name.toUpperCase();
                } else if (status_tag_name.equalsIgnoreCase(this.dasl_prefix + this.like_name)) {
                    query_block.append(this.sql_like_name.toUpperCase() + " '" + ((DASLDocument.Text)o).getContent() + "' ");
                }
                if (operation != null) {
                    query_block.append(operation + " '" + ((DASLDocument.Text)o).getContent() + "' ");
                }
            }
            if (!(o instanceof DASLDocument.Text) || !status || !status_tag_name.equalsIgnoreCase(this.dasl_prefix + this.contains_name)) continue;
            query_block.append(this.sql_contains_name.toUpperCase() + "(*, '" + ((DASLDocument.Text)o).getContent() + "') ");
        }
        return query_block.toString();
    }

    public String convertOrderby(DASLDocument doc) {
        boolean status = false;
        boolean prop_status = false;
        StringBuffer query_block = new StringBuffer(this.sql_orderby_name.toUpperCase() + " ");
        Enumeration e = doc.getElements().elements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            String type = ((DASLDocument.DASLElement)o).getType();
            String name = ((DASLDocument.DASLElement)o).getName();
            if (type.equalsIgnoreCase(this.start_tag_type) && name.equalsIgnoreCase(this.dasl_prefix + this.order_name)) {
                status = true;
            }
            if (type.equalsIgnoreCase(this.end_tag_type) && name.equalsIgnoreCase(this.dasl_prefix + this.order_name)) {
                status = false;
            }
            if (type.equalsIgnoreCase(this.start_tag_type) && name.equalsIgnoreCase(this.dasl_prefix + this.prop_name) && status) {
                prop_status = true;
            }
            if (type.equalsIgnoreCase(this.end_tag_type) && name.equalsIgnoreCase(this.dasl_prefix + this.prop_name) && status) {
                prop_status = false;
            }
            if (type.equalsIgnoreCase(this.empty_tag_type) && status && prop_status) {
                query_block.append(name + " ");
                continue;
            }
            if (type.equalsIgnoreCase(this.empty_tag_type) && name.equalsIgnoreCase(this.dasl_prefix + this.ascending_name) && status) {
                query_block.append(this.sql_ascending_name.toUpperCase() + this.sql_comma_name + " ");
            }
            if (!type.equalsIgnoreCase(this.empty_tag_type) || !name.equalsIgnoreCase(this.dasl_prefix + this.descending_name) || !status) continue;
            query_block.append(this.sql_descending_name.toUpperCase() + this.sql_comma_name + " ");
        }
        if (!query_block.toString().equalsIgnoreCase(this.sql_orderby_name.toUpperCase() + " ")) {
            query_block.delete(query_block.length() - this.sql_comma_name.length() - 1, query_block.length() - 1);
            return query_block.toString();
        }
        return "";
    }
}

