/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.exoplatform.commons.xml.ExoXPPParser;

public class ExoProperties
extends HashMap {
    public ExoProperties() {
    }

    public ExoProperties(int size) {
        super(size);
    }

    public String getProperty(String key) {
        return (String)this.get(key);
    }

    public void setProperty(String key, String value) {
        this.put(key, value);
    }

    public void addPropertiesFromText(String text) {
        String[] temp = text.split("\n");
        for (int i = 0; i < temp.length; ++i) {
            String[] value;
            temp[i] = temp[i].trim();
            if (temp[i].length() <= 0 || (value = temp[i].split("=")).length != 2) continue;
            this.put(value[0].trim(), value[1].trim());
        }
    }

    public String toText() {
        StringBuffer b = new StringBuffer();
        Set set = this.entrySet();
        for (Map.Entry entry : set) {
            b.append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
        }
        return b.toString();
    }

    public void addPropertiesFromXml(String xml) {
        try {
            ExoXPPParser xpp = ExoXPPParser.getInstance();
            xpp.setInput(new StringReader(xml));
            xpp.mandatoryNode("properties");
            while (xpp.node("property")) {
                this.put(xpp.getNodeAttributeValue("key"), xpp.getNodeAttributeValue("value"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String toXml() {
        StringBuffer b = new StringBuffer();
        b.append("<properties>");
        Set set = this.entrySet();
        for (Map.Entry entry : set) {
            b.append("<property key=\"").append(entry.getKey()).append("\" value=\"").append(entry.getValue()).append("\"/>");
        }
        b.append("</properties>");
        return b.toString();
    }
}

