/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;

public class IOUtil {
    public static String getFileContenntAsString(File file, String encoding) throws Exception {
        FileInputStream is = new FileInputStream(file);
        return new String(IOUtil.getStreamContentAsBytes(is), encoding);
    }

    public static String getFileContenntAsString(File file) throws Exception {
        FileInputStream is = new FileInputStream(file);
        return new String(IOUtil.getStreamContentAsBytes(is));
    }

    public static String getFileContenntAsString(String fileName, String encoding) throws Exception {
        FileInputStream is = new FileInputStream(fileName);
        return new String(IOUtil.getStreamContentAsBytes(is), encoding);
    }

    public static String getFileContenntAsString(String fileName) throws Exception {
        FileInputStream is = new FileInputStream(fileName);
        return new String(IOUtil.getStreamContentAsBytes(is));
    }

    public static byte[] getFileContentAsBytes(String fileName) throws Exception {
        FileInputStream is = new FileInputStream(fileName);
        return IOUtil.getStreamContentAsBytes(is);
    }

    public static String getStreamContentAsString(InputStream is) throws Exception {
        char[] buf = new char[is.available()];
        BufferedReader in = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        in.read(buf);
        return new String(buf);
    }

    public static byte[] getStreamContentAsBytes(InputStream is) throws Exception {
        byte[] buf = new byte[is.available()];
        for (int start = 0; start < buf.length; start += is.read(buf, start, buf.length - start)) {
        }
        return buf;
    }

    public static String getResourceAsString(String resource) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL url = cl.getResource(resource);
        InputStream is = url.openStream();
        return IOUtil.getStreamContentAsString(is);
    }

    public static byte[] getResourceAsBytes(String resource) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL url = cl.getResource(resource);
        InputStream is = url.openStream();
        return IOUtil.getStreamContentAsBytes(is);
    }

    public static byte[] serialize(Object obj) throws Exception {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bytes);
        out.writeObject(obj);
        out.close();
        byte[] ret = bytes.toByteArray();
        return ret;
    }

    public static Object deserialize(byte[] bytes) throws Exception {
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        ObjectInputStream in = new ObjectInputStream(is);
        Object obj = in.readObject();
        in.close();
        return obj;
    }
}

