/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.IOException;
import java.util.Properties;

public class MimeTypeResolver {
    private Properties mimeTypes = new Properties();
    private String defaultMimeType = "application/octet-stream";

    public MimeTypeResolver() {
        try {
            this.mimeTypes.load(this.getClass().getResourceAsStream("mimetypes.properties"));
        }
        catch (IOException e) {
            throw new InternalError("Unable to load mimetypes: " + e.toString());
        }
    }

    public String getDefaultMimeType() {
        return this.defaultMimeType;
    }

    public void setDefaultMimeType(String defaultMimeType) {
        this.defaultMimeType = defaultMimeType;
    }

    public String getMimeType(String filename) {
        String ext = filename.substring(filename.lastIndexOf(".") + 1);
        if (ext.equals("")) {
            ext = filename;
        }
        return this.mimeTypes.getProperty(ext.toLowerCase(), this.defaultMimeType);
    }
}

