/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.RootContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExoContainerContext
implements Serializable {
    private static ThreadLocal currentContainer = new ThreadLocal();
    private static ExoContainer topContainer;
    private HashMap<String, Object> attributes = new HashMap();
    private ExoContainer container;
    private String name;

    public ExoContainerContext(ExoContainer container) {
        this.container = container;
    }

    public ExoContainer getContainer() {
        return this.container;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static ExoContainer getTopContainer() {
        if (topContainer == null) {
            topContainer = RootContainer.getInstance();
        }
        return topContainer;
    }

    static void setTopContainer(ExoContainer cont) {
        if (topContainer != null && cont != null) {
            throw new RuntimeException("Two top level containers created, but must be only one.");
        }
        topContainer = cont;
    }

    public static ExoContainer getCurrentContainer() {
        ExoContainer container = (ExoContainer)((Object)currentContainer.get());
        if (container == null) {
            container = ExoContainerContext.getTopContainer();
        }
        return container;
    }

    public static ExoContainer getCurrentContainerIfPresent() {
        ExoContainer container = (ExoContainer)((Object)currentContainer.get());
        if (container == null) {
            return topContainer;
        }
        return container;
    }

    public static void setCurrentContainer(ExoContainer instance) {
        currentContainer.set(instance);
    }

    public static ExoContainer getContainerByName(String name) {
        if (topContainer.getContext().getName().equals(name)) {
            return topContainer;
        }
        return (ExoContainer)((Object)topContainer.getComponentInstance(name));
    }

    public Set<String> getAttributeNames() {
        return this.attributes.keySet();
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }
}

