/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.SessionContainer;
import org.exoplatform.container.SessionManager;
import org.exoplatform.container.SessionManagerContainer;
import org.exoplatform.container.SessionManagerImpl;
import org.exoplatform.container.configuration.ConfigurationException;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.configuration.ConfigurationManagerImpl;
import org.exoplatform.container.jmx.MX4JComponentAdapterFactory;
import org.exoplatform.container.monitor.jvm.J2EEServerInfo;
import org.exoplatform.container.util.ContainerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandaloneContainer
extends ExoContainer
implements SessionManagerContainer {
    private static final long serialVersionUID = 12L;
    private static final String CONFIGURATION_URL_ATTR = "configurationURL";
    private static StandaloneContainer container;
    private static URL configurationURL;
    private SessionManager smanager_;
    private ConfigurationManagerImpl configurationManager = new ConfigurationManagerImpl(null);

    private StandaloneContainer() {
        super(new MX4JComponentAdapterFactory(), null);
        this.registerComponentInstance(ConfigurationManager.class, this.configurationManager);
        this.registerComponentImplementation(SessionManagerImpl.class);
    }

    public static StandaloneContainer getInstance() throws Exception {
        return StandaloneContainer.getInstance(null, null);
    }

    public static StandaloneContainer getInstance(ClassLoader configClassLoader) throws Exception {
        return StandaloneContainer.getInstance(configClassLoader, null);
    }

    public static StandaloneContainer getInstance(Object[][] components) throws Exception {
        return StandaloneContainer.getInstance(null, components);
    }

    public static StandaloneContainer getInstance(ClassLoader configClassLoader, Object[][] components) throws Exception {
        if (container == null) {
            container = new StandaloneContainer();
            StandaloneContainer.initConfigurationURL(configClassLoader);
            container.populate(configurationURL);
            if (components != null) {
                container.registerArray(components);
            }
            container.start();
            ExoContainerContext.setTopContainer(container);
            System.setProperty("exo.standalone-container", StandaloneContainer.class.getName());
            System.out.println("StandaloneContainer initialized using:  " + configurationURL);
        }
        return container;
    }

    protected void registerArray(Object[][] components) {
        for (Object[] comp : components) {
            if (comp.length != 2 || comp[0] == null || comp[1] == null || comp[0].getClass().getName() != String.class.getName()) continue;
            String n = (String)comp[0];
            Object o = comp[1];
            container.registerComponentInstance(n, o);
            System.out.println("StandaloneContainer: injecting \"" + n + "\"");
        }
    }

    public static void setConfigurationURL(String url) throws MalformedURLException {
        if (url == null || url.length() == 0) {
            return;
        }
        URL confURL = new URL(url);
        configurationURL = StandaloneContainer.fileExists(confURL) ? confURL : null;
    }

    public static void setConfigurationPath(String path) throws MalformedURLException {
        if (path == null || path.length() == 0) {
            return;
        }
        URL confURL = new File(path).getAbsoluteFile().toURL();
        configurationURL = StandaloneContainer.fileExists(confURL) ? confURL : null;
    }

    public SessionContainer createSessionContainer(String id) {
        SessionContainer scontainer = this.getSessionManager().getSessionContainer(id);
        if (scontainer != null) {
            this.getSessionManager().removeSessionContainer(id);
        }
        scontainer = new SessionContainer(id, null);
        this.getSessionManager().addSessionContainer(scontainer);
        SessionContainer.setInstance(scontainer);
        return scontainer;
    }

    @Override
    public SessionContainer createSessionContainer(String id, String owner) {
        return this.createSessionContainer(id);
    }

    @Override
    public List<SessionContainer> getLiveSessions() {
        return this.getSessionManager().getLiveSessions();
    }

    @Override
    public void removeSessionContainer(String sessionID) {
        this.getSessionManager().removeSessionContainer(sessionID);
    }

    @Override
    public MBeanServer getMBeanServer() {
        return MBeanServerFactory.createMBeanServer("exomx");
    }

    public URL getConfigurationURL() {
        return configurationURL;
    }

    public void stop() {
        super.stop();
        ExoContainerContext.setTopContainer(null);
    }

    @Override
    public SessionManager getSessionManager() {
        if (this.smanager_ == null) {
            this.smanager_ = (SessionManager)this.getComponentInstanceOfType(SessionManager.class);
        }
        return this.smanager_;
    }

    private static boolean fileExists(URL url) {
        try {
            url.openStream().close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void initConfigurationURL(ClassLoader configClassLoader) throws MalformedURLException, ConfigurationException {
        if (configurationURL == null) {
            configurationURL = new URL("file:/" + new J2EEServerInfo().getServerHome() + "/exo-configuration.xml");
            if (!StandaloneContainer.fileExists(configurationURL) && configClassLoader != null) {
                configurationURL = configClassLoader.getResource("conf/exo-configuration.xml");
            }
            if (!StandaloneContainer.fileExists(configurationURL) && (configurationURL = Thread.currentThread().getContextClassLoader().getResource("conf/standalone/configuration.xml")) == null) {
                throw new ConfigurationException("No StandaloneContainer config found. Check if conf/standalone/configuration.xml exists !");
            }
        }
    }

    private static URL configurationURL() {
        return (URL)container.getContext().getAttribute(CONFIGURATION_URL_ATTR);
    }

    private void populate(URL conf) throws Exception {
        this.configurationManager.addConfiguration(conf);
        this.configurationManager.processRemoveConfiguration();
        ContainerUtil.addComponents(this, this.configurationManager);
    }

    private void populateGroovy(URL conf) throws Exception {
        this.configurationManager.addConfiguration(conf);
        this.configurationManager.processRemoveConfiguration();
    }

    static {
        configurationURL = null;
    }
}

