/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.SessionContainer;
import org.exoplatform.container.SessionManager;
import org.exoplatform.container.SessionManagerImpl;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.configuration.ConfigurationManagerImpl;
import org.exoplatform.container.jmx.MX4JComponentAdapterFactory;
import org.exoplatform.container.monitor.jvm.J2EEServerInfo;
import org.exoplatform.container.util.ContainerUtil;

public class StandaloneContainer
extends ExoContainer {
    private static StandaloneContainer container;
    private static URL configurationURL;
    private SessionManager smanager_;
    private ConfigurationManagerImpl configurationManager = new ConfigurationManagerImpl(null);

    private StandaloneContainer() {
        super(new MX4JComponentAdapterFactory(), null);
        this.registerComponentInstance(ConfigurationManager.class, this.configurationManager);
        this.registerComponentImplementation(SessionManagerImpl.class);
    }

    public static StandaloneContainer getInstance() throws Exception {
        if (container == null) {
            container = new StandaloneContainer();
            URL config = container.initConfig(Thread.currentThread().getContextClassLoader().getResource("conf/standalone/configuration.xml"), configurationURL);
            if (config == null) {
                throw new Exception("*** No StandaloneContainer config found. Check if conf/standalone/configuration.xml exists !");
            }
            container.populate(config);
            Iterator c = container.getComponentAdapters().iterator();
            container.start();
            System.setProperty("exo.standalone-container", StandaloneContainer.class.getName());
        }
        return container;
    }

    public SessionContainer createSessionContainer(String id) {
        SessionContainer scontainer = this.getSessionManager().getSessionContainer(id);
        if (scontainer != null) {
            this.getSessionManager().removeSessionContainer(id);
        }
        scontainer = new SessionContainer(id, null);
        this.getSessionManager().addSessionContainer(scontainer);
        SessionContainer.setInstance(scontainer);
        return scontainer;
    }

    public void removeSessionContainer(String sessionID) {
        this.getSessionManager().removeSessionContainer(sessionID);
    }

    public static void setConfigurationURL(String url) throws MalformedURLException {
        if (url == null || url.length() == 0) {
            return;
        }
        configurationURL = new URL(url);
    }

    public static void setConfigurationPath(String url) throws MalformedURLException {
        if (url == null || url.length() == 0) {
            return;
        }
        configurationURL = new File(url).getAbsoluteFile().toURL();
    }

    public MBeanServer getMBeanServer() {
        return MBeanServerFactory.createMBeanServer("exojcrmx");
    }

    public URL getConfigurationURL() {
        return configurationURL;
    }

    private SessionManager getSessionManager() {
        if (this.smanager_ == null) {
            this.smanager_ = (SessionManager)this.getComponentInstanceOfType(SessionManager.class);
        }
        return this.smanager_;
    }

    private URL initConfig(URL base, URL additional) {
        URL result = base;
        if (this.fileExists(additional)) {
            result = additional;
        } else {
            try {
                URL local = new URL("file:/" + new J2EEServerInfo().getServerHome() + "/configuration.xml");
                if (this.fileExists(local)) {
                    result = local;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        configurationURL = result;
        return result;
    }

    private boolean fileExists(URL url) {
        try {
            return new File(url.toURI()).exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    private void populate(URL conf) throws Exception {
        this.configurationManager.addConfiguration(conf);
        this.configurationManager.processRemoveConfiguration();
        ContainerUtil.addComponents(this, this.configurationManager);
    }

    private void populateGroovy(URL conf) throws Exception {
        this.configurationManager.addConfiguration(conf);
        this.configurationManager.processRemoveConfiguration();
    }

    public ConfigurationManagerImpl getConfigurationManager() {
        return this.configurationManager;
    }

    static {
        configurationURL = null;
    }
}

